var WEBBase = require("../../web.base");
var system = require("../../../system");
class PatentQueryAPI extends WEBBase {
    constructor() {
        super();
        this.patentSve = system.getObject("service.patent.patentycSve");
    }

    /**
     * 接口跳转-POST请求
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springBoard(pobj, qobj, req) {
        console.log("==================================================");
        console.log(pobj);
        console.log("==================================================");
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }

    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "test": //测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "CommomSearchbyApplicant"://根据申请人查询聚合
            case "paCountByApplicantName"://根据申请人获取专利量
            case "paShortListByApplicantName"://根据申请人获取专利详情列表
            case "paDetailsBypubNo"://根据公开或授权号获取专利详情列表
            case "paDetailsByfilingNo"://根据申请号获取专利详情列表
            case "softwareCountByAuthor"://根据公司名称得到软著量
            case "softwareListByAuthor"://根据公司名称得到软著详情
            case "softwareDetailsByregNum"://根据登记号获取软著详情
            case "worksCountByAuthor"://根据公司名称得到著作权量
            case "worksListByAuthor"://根据公司名称得到著作权详情
            case "worksDetailsByregNum"://根据登记号获取著作权详情
            case "CommomSearchbyTitle"://根据标题查询聚合
            case "CommomSearchbyInventor"://根据发明人查询聚合
            case "CommomSearchbyFilingno"://根据申请号查询聚合
            case "CommomSearchbyPubno"://根据公开号查询聚合
            case "AffairsearchbyFilingno"://根据申请号查询并根据法律状态日期排序
            case "paDataOrderByPubno"://查询所有专利，按公开日倒序排列
                opResult = await this.patentSve.opReqResult(pobj, req);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = PatentQueryAPI;