//百度工商注册
var APIBase = require("../../api.base");
var system = require("../../../system");
const regCfg = require("./regCfg");

class Feedback extends APIBase {
    constructor() {
    super();
    this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    //需求反馈
    async submit(pobj,req) {
        if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
            return regCfg.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.intentionBizId) {
            return regCfg.getResultFail("intentionBizId不能为空");
        }
        if (!pobj.description) {
            return regCfg.getResultFail("description不能为空");
        }
        if (!pobj.intentionStatus) {
            return regCfg.getResultFail("intentionStatus不能为空");
        }
        pobj.action_type = "regFeedbackSubmit";
        var param = {
            requestId: req.requestId || regCfg.getUUID(),
            requestUrl: "/ic/feedback/submit",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "regFeedbackSubmit",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await this.gatewaypushlogSve.create(param);
        return regCfg.getResultSuccess(param.requestId);
    }


}
module.exports = Feedback;