var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends WEBBase {
    constructor() {
        super();
        this.utilsOpOrderSve = system.getObject("service.utilsSve.utilsOpOrderSve");
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
        this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "opAliDingInterfaceManage"://操作阿里钉钉接口管理---actionBody:{为阿里需要的参数}
                var pushInterfaceResult = await this.utilsOpOrderSve.getOpInterfaceByProductId(pobj.appInfo, pobj.product_id);
                if (pushInterfaceResult.status != 0) {
                    return pushInterfaceResult;
                }
                var interface_list_temp = pushInterfaceResult.data.filter(f => f.op_type == "createAliTmApply")
                if (!interface_list_temp || interface_list_temp.length == 0) {
                    return system.getResult(null, "暂无【createAliTmApply】的推送配置，100520");
                }
                pobj.interface_params = interface_list_temp[0].params;
                opResult = await this.utilsTmAliyunSve.opAliDingInterfaceManage(pobj);
                break;
            // case "checkTmNameByAli"://检测商标名称是否合规
            //     var pushInterfaceResult = await this.utilsOpOrderSve.getOpInterfaceByProductId(pobj, pobj.actionBody.product_id);
            //     if (pushInterfaceResult.status != 0) {
            //         pobj.actionBody.product_info.interface_info = pushInterfaceResult.data;
            //         this.utilsPushSve.pushBusInfo(pobj, "closeAliTmApply", 1);
            //     }
            //     break;
            case "updateContacts"://修改订单联系人
                opResult = await this.utilsOpOrderSve.updateContacts(pobj, pobj.actionBody);
                break;
            case "updateTmOrder"://修改商标订单信息
                opResult = await this.utilsOpOrderSve.updateTmOrder(pobj, pobj.actionBody);
                break;
            case "tmConfirm"://商标方案确认
                opResult = await this.utilsOpOrderSve.tmConfirm(pobj, pobj.actionBody);
                break;
            case "sendAliWtsEmail"://推送委托书模板邮件(阿里云)
                opResult = await this.utilsTmAliyunSve.sendAliWtsEmail(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = ProductAPI;
