var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class AccessAuthAPI extends APIBase {
    constructor() {
        super();
        this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
    }
    /**
          * 接口跳转-POST请求
          * action_process  执行的流程
          * action_type     执行的类型
          * action_body     执行的参数
          */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = system.getResult(null, "req Failure");
        pobj.actionBody.userpin = pobj.actionBody.userpin || this.getUUID();
        switch (action_type) {
            // sy
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "getLoginByUserName"://渠道通过账户进行登录，有则返回用户信息，没有则创建用户
                opResult = await this.utilsAuthSve.getLoginByUserName(req, pobj, pobj.actionBody);
                break;
            case "getVerifyCode"://获取默认模板的手机验证码
                opResult = await this.utilsAuthSve.getVerifyCodeByMoblie(req, pobj, pobj.actionBody);
                if (opResult.status == 0) {
                    return system.getResultSuccess()
                }
                break;
            case "userPinByLgoin"://通过账户和密码登录
                opResult = await this.utilsAuthSve.getReqUserPinByLgoin(req, pobj, pobj.actionBody);
                if (opResult.status == 0) {
                    return opResult;
                }
                break;
            case "userPinByLgoinVcode"://通过短信登录信息
                pobj.actionBody.reqType = "login";
                opResult = await this.utilsAuthSve.getReqUserPinByLgoinVcode(req, pobj, pobj.actionBody);
                // if (opResult.status == 0) {
                //     return system.getResultSuccess({ userpin: pobj.actionBody.userpin })
                // }
                break;
            case "userPinByRegister"://通过短信注册信息
                pobj.actionBody.reqType = "reg";
                opResult = await this.utilsAuthSve.getReqUserPinByLgoinVcode(req, pobj, pobj.actionBody);
                // if (opResult.status == 0) {
                //     return system.getResultSuccess({ userpin: pobj.actionBody.userpin })
                // }
                break;
            case "putUserPwdByMobile"://通过手机验证码修改用户密码
                opResult = await this.utilsAuthSve.putUserPwdByMobile(pobj, pobj.actionBody);
                break;
            case "getLoginInfo"://通过userpin获取用户登录信息
                opResult = await this.utilsAuthSve.getLoginInfo(pobj, pobj.actionBody);
                break;
            case "logout"://用户退出
                opResult = await this.utilsAuthSve.userLogout(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }


    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      */
    async getAppTokenByHosts(pobj, qobj, req) {
        var token = this.getUUID();
        pobj.actionBody.reqType = "hosts";
        let opResult = await this.utilsAuthSve.getReqTokenByHosts(pobj.actionBody, token);
        return opResult;
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      */
    async getAppTokenByAppKey(pobj, qobj, req) {
        var token = this.getUUID();
        pobj.actionBody.reqType = "appkey";
        let opResult = await this.utilsAuthSve.getReqTokenByHosts(pobj.actionBody, token);
        return opResult;
    }
}
module.exports = AccessAuthAPI;