var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
/**
 * 商标方案信息（接收fqboss推送的商标方案信息，并推送至渠道）
 * 庄冰 2021.03.18
 */
class Tmcase extends APIBase {
    constructor() {
        super();
        this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
        this.baseUrl = settings.centerOrderUrl()+"notifyaction/opNeedSolution/"
    }

    async updateTmStatus(pobj, qobj, req) {
        var reqUrl = this.baseUrl + "updateTmStatus";
        var result = await this.utilsNeedSve.restPostUrl(pobj,reqUrl);
        return result;
    }
    //接收辅助、担保商标注册信息
    async nbtzreceiveAssistTmData(pobj, qobj, req) {
        var reqUrl = this.baseUrl + "nbtzreceiveAssistTmData";
        var result = await this.utilsNeedSve.restPostUrl(pobj,reqUrl);
        if(result && result.status==0){
            await this.pushData2Platform()
        }
        return result;
    }
    //接收辅助、担保商标注册修改信息
    async nbtzreceiveEditAssistTmData(pobj, qobj, req) {
        var reqUrl = this.baseUrl + "nbtzreceiveEditAssistTmData";
        var result = await this.utilsNeedSve.restPostUrl(pobj,reqUrl);
        return result;
    }

    //提交方案确认
    async submitTmConfirm(pobj, qobj, req) {
        if (!pobj.IntentionBizId) {
            return self.getResultFail("IntentionBizId不能为空");
        }
        var reqUrl = this.baseUrl + "nbtzreceiveEditAssistTmData";
        var result = await this.utilsNeedSve.restPostUrl(pobj,reqUrl);
        return result;
    }
    /**
     * 关闭注册⽅案
     * @param {*} pobj 
     * @param {*} obj 
     * @param {*} req 
     */
    async closeSolution(pobj,obj,req){
        if (!pobj.BizId) {
            return self.getResultFail("BizId不能为空");
        }
        if (!pobj.IntentionBizId) {
            return self.getResultFail("IntentionBizId不能为空");
        }
        var reqUrl = this.baseUrl + "closeSolution";
        var result = await this.utilsNeedSve.restPostUrl(pobj,reqUrl);
        return result;
    }

    /**
     * 推送数据至平台方（百度、阿里）
     * needSolution 需求方案
     * appInfo app
     * opflag 操作标志：QueryTradeIntentionUserList：查询需求列表，SaveTradeMarkProductSolution：提交注册⽅案-商标信息
     * SaveTradeMarkMaterialDetail：补全注册⽅案-申请⼈信息 ConfirmTradeIntention：确认注册⽅案
     * 
     */
    async pushData2Platform(needSolution,appInfo,opflag){
        if(appInfo.uapp_id==18){//阿里云商机

        }
        if(appInfo.uapp_id==44){//百度云商机
            
        }
    }

}
module.exports = Tmcase;