const system = require("../../../system");
const Dao = require("../../dao.base");
const {Op} = require("sequelize");

class OrderInfoDao extends Dao {
    constructor() {
        super(Dao.getModelName(OrderInfoDao));
    }

    /**
     * 更新订单
     * @param status
     * @param statusName
     * @param channelOrderNo
     * @param uapp_id
     * @returns {Promise<*>}
     */
    async updateStatus(status, statusName, channelOrderNo, uapp_id) {
        let result = await this.updateByWhere({orderStatus: status, orderStatusName: statusName}, {
            where: {
                channelOrderNo: channelOrderNo,
                uapp_id: uapp_id,
            }
        });
        return result;
    }

    async getItemStatusByOrderNo(orderNo, uapp_id) {
        var sqlWhere = {
            where: {
                orderNo: orderNo
            },
            attributes: [
                "id",
                "uapp_id",
                "orderNo",
                "channelServiceNo",
                "channelOrderNo",
                "orderServiceNo",
                "channelUserId",
                "ownerUserId",
                "payTime",
                "quantity",
                "serviceQuantity",
                "orderStatusName",
                "orderStatus",
                "totalSum",
                "payTotalSum",
                "refundSum",
                "invoiceApplyStatus",
                "created_at"],
            raw: true
        };
        if (uapp_id) {
            sqlWhere.where.uapp_id = uapp_id;
        }
        return await this.model.findOne(sqlWhere);
    }

    async getItemStatusByChannelOrderNo(channelOrderNo, uapp_id) {
        var sqlWhere = {
            where: {
                channelOrderNo: channelOrderNo
            },
            attributes: [
                "id",
                "uapp_id",
                "orderNo",
                "channelServiceNo",
                "channelOrderNo",
                "orderServiceNo",
                "channelUserId",
                "ownerUserId",
                "payTime",
                "quantity",
                "serviceQuantity",
                "orderStatusName",
                "orderStatus",
                "totalSum",
                "payTotalSum",
                "refundSum",
                "invoiceApplyStatus",
                "created_at"],
            raw: true
        };
        if (uapp_id) {
            sqlWhere.where.uapp_id = uapp_id;
        }
        return await this.model.findOne(sqlWhere);
    }

    async delOrderByOrderNo(orderNo, uapp_id, channelUserId) {
        var sqlWhere = {
            orderNo: orderNo,
            uapp_id: uapp_id,
            channelUserId: channelUserId
        };
        return await this.delete(sqlWhere);
    }

    async delOrderByOrderNoEname(orderNo) {
        var sqlWhere = {
            orderNo: orderNo
        };
        return await this.delete(sqlWhere);
    }

    async channeldelOrder(channelOrderNo, uapp_id) {
        var sqlWhere = {
            channelOrderNo: channelOrderNo,
            uapp_id: uapp_id,
        };
        return await this.delete(sqlWhere);
    }

    async addOrderDelivery(data, orderNo, t) {//新增交付信息
        const sql = "INSERT INTO  `c_order_delivery` (`sourceOrderNo`,`deliveryContent`) VALUE('" +
            orderNo + "','" + JSON.stringify(data) + "')";
        await this.customInsert(sql, null, t);
        return system.getResultSuccess()
    }

    /**
     * 根据ids 获取需求
     * @param ids
     * @returns {Promise<void>}
     */
    async getOrdersByIds(ids) {
        let orders = await this.findAll({
            where: {
                channelOrderNo: {
                    [Op.in]: ids
                }
            }
        })
        return orders;
    }

    /**
     * 批量更新
     * @param needs
     * @returns {Promise<Array<Model>|*>}
     */
    async bulkUpdate(orders) {
        let result = await this.bulkCreate(orders, {
            fields: ["id", "status", "statusName"],
            updateOnDuplicate: ["status", "statusName"]
        });
        return result;
    }

    /**
     * 批量更新
     * @param needs
     * @returns {Promise<Array<Model>|*>}
     */
    async bulkUpdateStatus(status, statusName, ids) {
        let result = await this.updateByWhere({orderStatus: status, orderStatusName: statusName}, {
            where: {
                channelOrderNo: {
                    [Op.in]: ids
                }
            }
        });
        return result;
    }
}

module.exports = OrderInfoDao;
