const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("needinfofq", {
    sourceCode: DataTypes.STRING(128), //来源code )idempotent_source
    channelNeedNo: DataTypes.STRING(128), //渠道需求号（页面中列表中显示该需求号）
    publishContent: DataTypes.TEXT,//发布内容
    publishMobile: DataTypes.STRING,//发布者手机号
    followContent: DataTypes.TEXT,//跟进内容
    notes: DataTypes.TEXT,//备注
    disposeNotes: DataTypes.STRING,//处理的备注
    statusName: DataTypes.STRING,
    status: DataTypes.INTEGER,
    city: DataTypes.STRING(50), // 城市
    province: DataTypes.STRING(50), // 省份
    typeCode: DataTypes.STRING(50), //产品类型编码',
    typeName: DataTypes.STRING(50), //类型产品名称',
    channelTypeCode: DataTypes.STRING(50), //渠道产品类型编码',
    channelTypeName: DataTypes.STRING(255), //渠道产品类型名称',
    handleStatus:DataTypes.INTEGER //处理状态，0否，1是
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'n_need_info_fq',
      validate: {

      },
      indexes: [

      ]
    });
}
