var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");

class tmreview extends APIBase{
    constructor() {
        super();
        this.orderDeliverSve = system.getObject("service.dbcorder.orderdeliverSve");
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
        this.needsolutionSve = system.getObject("service.dbneed.needsolutionSve");
    }

    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }

    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "addReviewList":
                opResult = await this.orderDeliverSve.submitReview(pobj,pobj.actionBody);
                break;
            case "getReOrderList"://获取订单列表信息
                opResult = await this.orderDeliverSve.getReOrderList(pobj, pobj.actionBody);
                break;
            case "addOfficial"://接收官文信息
                opResult = await this.orderDeliverSve.addOfficial(pobj,pobj.actionBody);
                break;
            case "getOfficalList":
                opResult = await this.orderDeliverSve.getOfficialList(pobj,pobj.actionBody)
                break;
            case "addOrderDelivery":
                opResult = await this.needsolutionSve.addOrderDelivery(pobj)
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}

module.exports = tmreview;