var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class OrderAPI extends APIBase {
    constructor() {
        super();
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
        this.utilsChannelTmDeliverySve = system.getObject("service.utilsSve.utilsChannelTmDeliverySve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (["addAliChannelTmApplicant", "updateAliChannelTm", "getAliChannelTmDelivery", "getAllAliChannelTmDelivery", "getOrderProductDeliveryByOrderNo"].indexOf(pobj.actionType) < 0) {
            if (!pobj.userInfo) {
                return system.getResultFail(system.noLogin, "user no login!");
            }
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "addAliChannelTmApplicant"://新增ali渠道商标交付信息
                opResult = await this.utilsChannelTmDeliverySve.addAliChannelTmApplicant(pobj.actionBody);
                break;
            case "updateAliChannelTm"://修改ali渠道商标信息
                opResult = await this.utilsChannelTmDeliverySve.updateAliChannelTm(pobj.actionBody);
                break;
            case "getAliChannelTmDelivery"://查询ali渠道商标交付信息
                opResult = await this.utilsChannelTmDeliverySve.getAliChannelTmDelivery(pobj.actionBody);
                break;
            case "getAllAliChannelTmDelivery"://查询ali渠道所有商标交付信息
                opResult = await this.utilsChannelTmDeliverySve.getAllAliChannelTmDelivery(pobj.actionBody);
                break;
            case "getOrderProductDeliveryByOrderNo"://获取订单产品及交付信息--用于钉钉商标推送
                opResult = await this.orderinfoSve.getOrderProductDeliveryByOrderNo(pobj.actionBody);
                break;
            case "updateContacts"://修改订单联系人
                opResult = await this.orderinfoSve.updateContacts(pobj, pobj.actionBody);
                break;
            case "updateTmOrder"://修改商标订单信息
                opResult = await this.orderinfoSve.updateTmOrder(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = OrderAPI;