const Dao = require("../../dao.base");
class AskForDao extends Dao {
  constructor() {
    super(Dao.getModelName(AskForDao));
  }

  async getByUid (uid, page = 1, offset = 11) {
    return await this.model.findAndCountAll({
      where: { user_id: uid, a_type: 1 },
      limit: offset,
      offset: (page - 1) * offset
    })
  }

  async create (param) {
    return await this.model.create(param)
  }

  async delete (id) {
    return await this.model.destroy({
      where: {
        id: id
      }
    })
  }
}
module.exports = AskForDao;