const system = require("../../../system");
const Dao = require("../../dao.base");
class UsuallyContactsDao extends Dao {
  constructor() {
    super(Dao.getModelName(UsuallyContactsDao));
  }
  async getItemByOrderNo(orderNo, uapp_id) {
    return await this.model.findOne({
      where: {
        sourceOrderNo: orderNo
      },
      attributes: [
        "id",
        "contactName",
        "mobile",
        "tel",
        "email",
        "fax"],
      raw: true
    });
  }
}
module.exports = UsuallyContactsDao;
