const system = require("../../../system");
const Dao = require("../../dao.base");
const {Op} = require("sequelize");
class NeedinfofqDao extends Dao {
  constructor() {
    super(Dao.getModelName(NeedinfofqDao));
  }

  /**
   * 取300条未处理的数据
   * @returns {Promise<Array<Model>>}
   */
  async getAllNeeds(){
    let fqNeeds = await this.findAll({
      where: {
        handleStatus: 0
      },
      order: [["id","desc"]],
      limit: 300
    })
    return fqNeeds;
  }

  /**
   * 批量更新
   * @param needs
   * @returns {Promise<Array<Model>|*>}
   */
  async bulkUpdate(ids){
    let result = await this.updateByWhere({handleStatus:1},{
      where : {
        channelNeedNo:{
          [Op.in]:ids
        }
      }
    });
    return result;
  }
}
module.exports = NeedinfofqDao;
