const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {//费用单：
  return db.define("expensevoucher", {
    uapp_id: DataTypes.INTEGER,      //  
    sourceOrderNo: DataTypes.STRING(128),   // 来源单号 
    expenseTypeName: DataTypes.STRING,
    expenseType: {//收款类型，gf: 官费, tax: 税金, channelSettleProfit: 订单渠道分润结算
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.expense_type),
      set: function (val) {
        this.setDataValue("expenseType", val);
        this.setDataValue("expenseTypeName", uiconfig.config.pdict.expense_type[val]);
      }
    },
    totalSum: DataTypes.DECIMAL(12, 3),//总额
    notes: DataTypes.STRING,//备注    
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_expensevoucher',
      validate: {
      }
    });
}
