const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("moneyjourney", {
    uapp_id: DataTypes.INTEGER,      //  
    sourceOrderNo: DataTypes.STRING(128),   // 来源单号 
    channelUserId: DataTypes.STRING(64),         //  渠道用户ID   
    ownerUserId: DataTypes.STRING(20),//   拥有渠道用户ID
    accountType: {
      //帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.pay_account_type),
      set: function (val) {
        this.setDataValue("accountType", val);
        this.setDataValue("accountTypeName", uiconfig.config.pdict.pay_account_type[val]);
      }
    },
    accountTypeName: {//帐户类型名称
      type: DataTypes.STRING,
    },
    directionTypeName: DataTypes.STRING,
    directionType: {//凭单类型,"sr": "收","zc": "支"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.direction_type),
      set: function (val) {
        this.setDataValue("directionType", val);
        this.setDataValue("directionTypeName", uiconfig.config.pdict.direction_type[val]);
      }
    },
    voucherDate: DataTypes.DATE,//凭单时间
    recvAmount: DataTypes.DECIMAL(12, 3),//收总额
    payAmount: DataTypes.DECIMAL(12, 3),//支总额
    sourceTypeName: DataTypes.STRING,
    sourceType: {//来源类型 "orderinfo": "订单","expensevoucher": "费用单"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.source_type),
      set: function (val) {
        this.setDataValue("sourceType", val);
        this.setDataValue("sourceTypeName", uiconfig.config.pdict.source_type[val]);
      }
    },
    auditStatusName: {
      type: DataTypes.STRING(50),
      defaultValue: "待审核",
    },
    auditStatus: {//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.audit_status),
      set: function (val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName", uiconfig.config.pdict.audit_status[val]);
      },
      defaultValue: "dsh",
    },
    notes: DataTypes.STRING,//备注
    opNotes: DataTypes.STRING,//操作备注
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_moneyjourney',
      validate: {
      }
    });
}
