const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("needsolution", {
    channelNeedNo: DataTypes.STRING(128), //渠道需求号（页面中列表中显示该需求号）
    needNo: DataTypes.STRING(128), //需求号--用于服务商或需求表中创建订单
    channelNeedNo: DataTypes.STRING(128), //渠道需求号（页面中列表中显示该需求号
    solutionNo: DataTypes.STRING(128), //方案号	
    channelSolutionNo: DataTypes.STRING(128), //渠道方案号（页面中列表中显示该单号）
    orderNo: DataTypes.STRING(128), //自己订单表中的orderNo	
    solutionContent: DataTypes.STRING,//
    status: {
      //"solution_status":{"ytj":"已提交","yfk":"已付款","yzf":"已作废","ytk":"已退款"},
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.solution_status),
      set: function (val) {
        this.setDataValue("status", val);
        this.setDataValue("statusName", uiconfig.config.pdict.solution_status[val]);
      }
    },
    statusName: DataTypes.STRING(50), //状态名称
    channelDeliverId: DataTypes.STRING(128), //服务单id
    createUserId: DataTypes.INTEGER, //创建者id
    isInvalid:DataTypes.INTEGER, //是否废弃的无效的方案
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'n_need_solution',
      validate: {

      },
      indexes: [

      ]
    });
}
