const system = require("../../../system");
const settings = require("../../../../config/settings");
const ServiceBase = require("../../sve.base");

class OrderInfoService extends ServiceBase {
    constructor() {
        super("dbcorder", ServiceBase.getDaoName(OrderInfoService));
        this.flowlogDao = system.getObject("db.dbcorder.flowlogDao");
        this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
        this.orderproductDao = system.getObject("db.dbcorder.orderproductDao");
        this.ordercontactsDao = system.getObject("db.dbcorder.ordercontactsDao");
        this.orderReceiptVoucherDao = system.getObject("db.dbcpay.orderreceiptvoucherDao");
        this.officialDao = system.getObject("db.dbcorder.orderofficialDao");
    }

    //----------------------订单创建-----------start----------------
    async createOrder(pobj, orderNo, t) {
        var actionBody = pobj.actionBody;
        var channelOrder = actionBody.channelOrder;
        var orderContact = actionBody.orderContact;
        var price_item = actionBody.product_info.price_item;
        var totalServiceCharge = Number(price_item.service_charge || 0) * Number(actionBody.quantity || 0);
        var totalPublicExpense = Number(price_item.public_expense || 0) * Number(actionBody.quantity || 0);
        var totalSupplyPrice = Number(price_item.supply_price || 0) * Number(actionBody.quantity || 0);//统计供货价格
        var totalProfitSum = Number(actionBody.totalSum) - Number(totalSupplyPrice || 0);//利润
        var pfProfitSum = (100 - Number(price_item.channel_profit_rate || 0)) / 100 * totalProfitSum;
        if (pfProfitSum < 0) {
            pfProfitSum = 0;
        }
        var channelProfitSum = Number(totalProfitSum) - Number(pfProfitSum);
        var payTime = channelOrder.payTime || new Date();
        var params = {
            uapp_id: pobj.appInfo.uapp_id,//int(11)       //
            orderNo: orderNo,//varchar(64)   //订单号
            channelServiceNo: channelOrder.channelServiceNo || orderNo,//varchar(64)   //渠道服务单号
            channelOrderNo: channelOrder.channelOrderNo || orderNo,//varchar(1024) //渠道订单号列表，多个以,隔开
            needNo: channelOrder.needNo || "",//需求号--用于服务商或需求表中创建订单
            channelUserId: pobj.userInfo.channel_userid,//varchar(64)   //
            ownerUserId: pobj.userInfo.channel_userid,//varchar(20)   //
            payTime: channelOrder.orderStatus && channelOrder.orderStatus == 2 ? payTime : null,//datetime      //
            quantity: actionBody.quantity,//int(11)       //项目订单数量（即服务项目的倍数，默认值为1）
            serviceQuantity: 0,//int(11)       //项目订单交付数量（即与项目订单数量相对应）
            orderStatus: channelOrder.orderStatus || 1,//int          //订单状态: 1: 待付款, 2: 已付款, 4: 待服务, 8: 已完成
            totalSum: actionBody.totalSum,//decimal(12,2) //订单总额(产品价格×优惠费率×订单件数)
            payTotalSum: actionBody.payTotalSum || actionBody.totalSum,//decimal(12,2) //
            refundSum: 0,//decimal(12,2) //退款总额
            totalServiceCharge: totalServiceCharge,//decimal(12,2) //服务费总额（产品配置的服务费*订单件数）
            totalPublicExpense: totalPublicExpense,//decimal(12,2) //官费总额（产品配置的官费*订单件数）
            totalProfitSum: totalProfitSum,//decimal(12,2) //订单毛利润总额（产品价格-供货价格））
            pfProfitSum: pfProfitSum,//decimal(12,2) //订单平台毛利润总额（(100-渠道利润分成比例)/100 * 订单毛利润总额）
            channelProfitSum: channelProfitSum,//decimal(12,2) //订单渠道分成毛利润总额(订单毛利润总额-平台毛利润总额)
            totalDiscounts: 0,//decimal(12,2) //优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）暂时没有用到
            pfSettleProfit: 0,//int(11)       //平台结算渠道利润,0否，1是
            invoiceApplyStatus: "00",//varchar(10)   //发票状态:00: 未申请, 10: 已申请,20:已开票
            notes: actionBody.notes || "",//varchar(255)  //
            opNotes: "",//varchar(255)  //操作备注
        };
        var order = await this.dao.create(params, t);//创建订单
        var orderLog = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,
            opContent: "您提交了订单，请及时支付",
            isShow: 1
        };
        await this.flowlogDao.create(orderLog, t);
        var orderProductObj = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,   // 来源单号
            productType_id: actionBody.product_info.productType_id,//产品类型Id
            pathCode: actionBody.product_info.path_code,//产品路径
            pathName: actionBody.product_info.path_name,//产品路径名称
            itemCode: actionBody.product_info.item_code,//产品编码
            itemName: actionBody.product_info.item_name,//产品名称
            channelItemCode: actionBody.product_info.channel_item_code,//  渠道产品编码
            channelItemName: actionBody.product_info.channel_item_name,//  渠道产品名称
            channelItemAppendName: actionBody.channelItemAppendName || "",//服务商产品附加名称
            serviceItemCode: actionBody.product_info.service_item_code,//  服务商产品编码
            payAfterJumpH5Url: actionBody.product_info.pay_after_jump_h5url || "",
            payAfterJumpPcUrl: actionBody.product_info.pay_after_jump_pcurl || "",
            picUrl: actionBody.product_info.pic_url,//  产品图片地址
            price: actionBody.product_info.price_item.price,//定价
            priceDesc: actionBody.product_info.price_item.price_desc,//定价描述
            priceTypeName: actionBody.product_info.price_item.price_type_name,//定价类型名称
            quantity: actionBody.quantity,//  订单数量（即产品的倍数，默认值为1）
            opPayType: "00",//  操作付款类型:00: 创建订单, 10: 补单
            serviceItemSnapshot: JSON.stringify(actionBody.product_info),      //产品快照
            orderSnapshot: JSON.stringify(actionBody.deliveryData.apply)
        };
        var orderProduct = await this.orderproductDao.create(orderProductObj, t);//订单产品
        var orderReceiptVoucherObj = {
            uapp_id: pobj.appInfo.uapp_id,
            sourceOrderNo: orderNo,   // 来源单号
            accountType: "other",
            payDate: payTime,//支付时间
            totalSum: actionBody.payTotalSum || actionBody.totalSum,//订单总额
            auditStatus: "dsh",
            wxPayOrderCode: orderNo,//业务微信支付订单号
            aliPayOrderCode: orderNo,//业务支付宝支付订单号
            busPayOrderCode: orderNo//业务支付订单号
        };
        if (orderContact && orderContact.mobile) {
            var customerContactObj = {
                uapp_id: pobj.appInfo.uapp_id,//int(11)       //
                sourceOrderNo: orderNo,//交付订单号
                contactName: orderContact.contacts || "",//手机号
                mobile: orderContact.mobile,//手机号
                email: orderContact.email || ""
            };
            await this.ordercontactsDao.create(customerContactObj, t);
        }
        var orderReceiptVoucher = await this.orderReceiptVoucherDao.create(orderReceiptVoucherObj, t);
    }

    /**
     * 创建其他订单
     * @param {*} pobj
     */
    async createOtherOrder(pobj) {
        var self = this;
        return await self.db.transaction(async function (t) {
            var orderNo = await self.getBusUid("ot" + pobj.appInfo.uapp_id);
            if (pobj.actionBody.channelOrder && pobj.actionBody.channelOrder.channelOrderNo) {
                var count = await self.dao.findCount({ where: { channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo } });
                if (count > 0) {
                    return system.getResultFail(-1, "订单不能重复创建s");
                }
            }
            var item = await self.createOrder(pobj, orderNo, t);
            return system.getResultSuccess({
                orderNo: orderNo,
                channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || orderNo,
                channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || orderNo,
                channelParams: pobj.actionBody.channelOrder.channelParams || ""
            });
        });

    }


    /**
     * 创建商标驳回复审订单
     * @param pobj
     * @returns {Promise<*>}
     */
    async createTmReOrder(pobj) {
        var packagingTmResult = await this.packagingTmReDeliveryData(pobj, pobj.actionBody);
        if (packagingTmResult.status != 0) {
            return packagingTmResult;
        }
        var self = this;
        return await self.db.transaction(async function (t) {
            var orderNo = await self.getBusUid("re" + pobj.appInfo.uapp_id);
            var item = await self.createOrder(pobj, orderNo, t);
            await self.orderinfoDao.addOrderDelivery(pobj.actionBody.deliveryData, orderNo, t);
            return system.getResultSuccess({
                orderNo: orderNo,
                channelServiceNo: pobj.actionBody.channelOrder.channelServiceNo || orderNo,
                channelOrderNo: pobj.actionBody.channelOrder.channelOrderNo || orderNo,
                channelParams: pobj.actionBody.channelOrder.channelParams || ""
            });
        });
    }

    /**
     * 重新组装交付信息
     * @param pobj
     * @param actionBody
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: *, status: number}|{msg: *, data: (*|null), status: number}>}
     */
    async packagingTmReDeliveryData(pobj, actionBody) {
        if (!actionBody.deliveryData || Object.keys(actionBody.deliveryData).length == 0) {
            return system.getResult(null, "交付数据不能为空，20135");
        }
        var deliveryData = actionBody.deliveryData;
        //商标申请信息
        const apply = deliveryData.apply;

        //商标申请人信息
        const applyUser = actionBody.deliveryData.applyUser;
        //复审证据材料
        const askForData = actionBody.deliveryData.askForData;

        //申请信息校验
        let re1 = await this.checkApply(apply);
        if (re1.status != 0) {
            return re1;
        }
        if (Object.keys(applyUser).length === 0 || Object.keys(askForData).length === 0) {
            var deliveryStatusName = "待完善材料";
            var recDate = "";
            var askforDate = "";
        } else {
            var deliveryStatusName = deliveryData.deliveryStatusName || "待审核";
            var recDate = deliveryData.reDate || "";
            var askforDate = deliveryData.askforDate || "";
        }
        pobj.actionBody.deliveryData.deliveryStatusName = deliveryStatusName;
        pobj.actionBody.deliveryData.deliveryUpdate = deliveryData.deliveryUpdate || new Date();
        pobj.actionBody.deliveryData.reDate = recDate;
        pobj.actionBody.deliveryData.askforDate = askforDate;
        pobj.actionBody.deliveryData.notes = actionBody.notes || ""; //  订单备注
        pobj.actionBody.deliveryData.opNotes = ""; //操作备注
        return system.getResultSuccess();
    }

    /**
     * 新增交付信息--废弃，从dao中调用，20201102-sy
     * @param data
     * @param orderNo
     */
    async addOrderDelivery(data, orderNo, t) {
        try {
            var sql = "INSERT INTO  `c_order_delivery` (`sourceOrderNo`,`deliveryContent`) VALUE('" +
                orderNo + "','" + JSON.stringify(data) + "')";
            await this.customInsert(sql);
            return system.getResultSuccess();
        } catch (e) {
            return system.getResultFail();
        }

    }

    /**
     * 修改交付信息
     * @param pobj
     * @param actionBody
     * @returns {Promise<{msg: *, data: (*|null), status: number}>}
     */
    async submitReview(pobj, actionBody) {
        try {
            var packagingTmResult = await this.packagingTmReDeliveryData(pobj, pobj.actionBody);
            if (packagingTmResult.status != 0) {
                return packagingTmResult;
            }
            const orderNo = actionBody.orderNo;
            const deliveryData = JSON.stringify(pobj.actionBody.deliveryData);
            let sql = `UPDATE c_order_delivery  SET deliveryContent ='${deliveryData}' where sourceOrderNo='${orderNo}'`;
            sql = sql.replace('\n', '');
            const result = await this.customUpdate(sql);
            return system.getResultSuccess();
        } catch (e) {
            return system.getResultFail();
        }
    }

    //申请信息校验
    async checkApply(apply) {
        if (!apply) {
            return system.getResult(null, "申请信息不能为空，20230");
        }
        if (!apply.askforId) {
            return system.getResult(null, "申请号为空");
        }
        if (!apply.applicantName) {
            return system.getResult(null, "申请人为空");
        }
        if (!apply.agentName) {
            return system.getResult(null, "代理机构为空");
        }
        if (!apply.tradeImg) {
            return system.getResult(null, "商标图样不能为空");
        }
        if (!apply.tradeType) {
            return system.getResult(null, '商标类别为空');
        }
        if (!apply.usccode) {
            return system.getResult(null, "申请统一社会信用代码不能为空");
        }
        return system.getResultSuccess();
    }

    /**
     * 商标驳回复审列表 + 模糊查询
     * @param pobj
     * @param actionBody
     * @returns {Promise<void>}
     */
    async getReOrderList(pobj, actionBody) {
        let pageSize = Number(actionBody.pageSize || 20);
        if (pageSize > 50) {
            pageSize = 50;
        }
        let pageIndex = Number(actionBody.pageIndex || 1);
        let from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);

        let sql = `SELECT orderNo,json_extract(d.deliveryContent,'$.apply.askforId') askforId,json_extract(d.deliveryContent,'$.apply.tradeType') tradeType,json_extract(d.deliveryContent,'$.apply.tradeImg') tradeImg,json_extract(d.deliveryContent,'$.applyUser.applicantName') applicantName,json_extract(d.deliveryContent,'$.deliveryStatusName') deliveryStatusName,json_extract(d.deliveryContent,'$.deliveryUpdated') deliveryUpdated,i.updated_at updated_at from c_order_info i left join c_order_delivery d on i.orderNo = d.sourceOrderNo where i.uapp_id = ${pobj.appInfo.uapp_id} and i.orderNo like 'RE%'`;
        let sqlCount = `SELECT count(1) as dataCount from c_order_info i left join c_order_delivery d on i.orderNo = d.sourceOrderNo where i.uapp_id = ${pobj.appInfo.uapp_id} and i.orderNo like 'RE%'`;

        if (pobj.userInfo.channel_userid) {
            sql += ` and i.channelUserId='${pobj.userInfo.channel_userid}'`;
            sqlCount += ` and i.channelUserId='${pobj.userInfo.channel_userid}'`;
        }
        if (actionBody.orderNo) {
            sql += ` and orderNo='${actionBody.orderNo}'`;
            sqlCount += ` and orderNo='${actionBody.orderNo}'`;
        }
        if (actionBody.askforId) {
            sql += ` and json_extract(deliveryContent,'$.apply.askforId')='${actionBody.askforId}'`;
            sqlCount += ` and json_extract(deliveryContent,'$.apply.askforId')='${actionBody.askforId}'`;
        }
        if (actionBody.applicantName) {
            sql += ` and json_extract(deliveryContent,'$.applyUser.applicantName') like '%${actionBody.applicantName}%'`;
            sqlCount += ` and json_extract(deliveryContent,'$.applyUser.applicantName') like '%${actionBody.applicantName}%'`;
        }
        if (actionBody.status) {
            sql += ` and json_extract(deliveryContent,'$.deliveryStatusName')='${actionBody.status}'`;
            sqlCount += ` and json_extract(deliveryContent,'$.deliveryStatusName')='${actionBody.status}'`;
        }

        if (actionBody.startTime && actionBody.entTime) {
            var startTime = actionBody.startTime.trim() + " 00:00:00";
            var endTime = actionBody.entTime + " 23:59:59";
            sql += ` and i.updated_at >= '${startTime}' and i.updated_at <= '${endTime}'`;
            sqlCount += ` and i.updated_at >= '${startTime}' and  i.updated_at <= '${endTime}'`;
        }

        sql += ` order by i.id desc LIMIT ${pageSize} OFFSET ${from}`;

        let list = await this.customQuery(sql);

        let result = system.getResultSuccess(list);

        let tmpResultCount = await this.customQuery(sqlCount);

        result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;

        return result;
    }


    /**
     * 官文列表
     * @param pobj
     * @param actionBody
     * @returns {Promise<void>}
     */
    async getOfficialList(pobj, actionBody) {
        let pageSize = Number(actionBody.pageSize || 20);
        if (pageSize > 50) {
            pageSize = 50;
        }
        let pageIndex = Number(actionBody.pageIndex || 1);
        let from = pageIndex == 1 ? 0 : Number((pageIndex - 1) * pageSize);

        let sql = `select o.serviceNo,json_extract(officialInfo,'$.dir') dir,json_extract(officialInfo,'$.askforId') askforId,json_extract(officialInfo,'$.tradeType') tmType,json_extract(officialInfo,'$.tradeImg') tmPicUrl,json_extract(officialInfo,'$.applicantName') applicantName,json_extract(officialInfo,'$.fileType') fileType,json_extract(officialInfo,'$.received_at') received_at from c_order_info i left join c_delivery_official o on i.orderNo = o.serviceNo  where i.uapp_id = ${pobj.appInfo.uapp_id}`;
        let sqlCount = `select count(1) as dataCount from c_order_info i left join c_delivery_official o on i.orderNo = o.serviceNo  where i.uapp_id = ${pobj.appInfo.uapp_id}`

        if (pobj.userInfo.channel_userid) {
            sql += ` and o.channelUserId='${pobj.userInfo.channel_userid}'`;
            sqlCount += ` and o.channelUserId='${pobj.userInfo.channel_userid}'`;
        }
        if (actionBody.orderNo) {
            sql += ` and o.serviceNo='${actionBody.orderNo}'`;
            sqlCount += ` and o.serviceNo='${actionBody.orderNo}'`;
        }
        if (actionBody.askforId) {
            sql += ` and json_extract(officialInfo,'$.askforId')='${actionBody.askforId}'`;
            sqlCount += ` and json_extract(officialInfo,'$.askforId')='${actionBody.askforId}'`;
        }
        if (actionBody.applicantName) {
            sql += ` and json_extract(officialInfo,'$.applicantName') like '%${actionBody.applicantName}%'`;
            sqlCount += ` and json_extract(officialInfo,'$.applicantName') like'%${actionBody.applicantName}%'`;
        }
        if (actionBody.fileType) {
            sql += ` and json_extract(officialInfo,'$.fileType')='${actionBody.fileType}'`;
            sqlCount += ` and json_extract(officialInfo,'$.fileType')='${actionBody.fileType}'`;
        }

        if (actionBody.startTime && actionBody.entTime) {
            var startTime = actionBody.startTime.trim();
            var endTime = actionBody.entTime;
            sql += ` and json_extract(officialInfo,'$.received_at') >='${startTime}' and  json_extract(officialInfo,'$.received_at')<='${endTime}'`;
            sqlCount += ` and json_extract(officialInfo,'$.received_at') >='${startTime}' and  json_extract(officialInfo,'$.received_at')<='${endTime}'`;
        }

        sql += ` order by o.id desc LIMIT ${pageSize} OFFSET ${from}`;

        let list = await this.customQuery(sql);

        let result = system.getResultSuccess(list);

        let tmpResultCount = await this.customQuery(sqlCount);

        result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;

        return result;
    }

    /**
     * 接收交付中心推送的官文
     * @param pobj
     * @param actionBody
     * @returns {Promise<void>}
     */
    async addOfficial(pobj, actionBody) {
        if (!actionBody.orderNo) {
            return system.getResult(null, 'orderNo can not be empty');
        }
        try {
            let orderSql = `select channelUserId from c_order_info where orderNo = '${actionBody.orderNo}'`;
            let list = await this.customQuery(orderSql);
            if (!list || list.length == 0) {
                return system.getResult(null, "订单数据为空，30200");
            }
            let orderItem = list[0];
            let data = {
                serviceNo: actionBody.orderNo,
                channelUserId: orderItem.channelUserId,
                officialInfo: actionBody.officialData,
                created_at: new Date(),
                updated_at: new Date()
            }
            await this.officialDao.create(data);
            return system.getResultSuccess();
        } catch (e) {
            return system.getResultFail();
        }

    }
}

module.exports = OrderInfoService;