const uuidv4 = require('uuid/v4');
const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
var moment = require('moment')
class NeedinfoService2 extends ServiceBase {
  constructor() {
    super("dbneed", ServiceBase.getDaoName(NeedinfoService2));
    this.execlient = system.getObject("util.execClient");
  }

  async writeCommunicationLog(pobj, actionBody) {
    console.log('actionBody---writeCommunicationLog---',actionBody)
    // 查询需求沟通记录
    // 2020 0820 lin 修改channel传过来的参数 为 note/intentionBizId
    actionBody.Note = ["noteTime", moment().format("YYYY-MM-DD HH:mm:ss"), "note", actionBody.note];
    let needRes = await this.findOne({ channelNeedNo: actionBody.intentionBizId });
    // 没有需求单直接返回
    if (!needRes) {
      return system.getResult("没有这个需求单");
    }
    // 如果未推送/以推送 修改为已跟进
    if (needRes.status == "wts" || needRes.status == "yts") {
      var sql = "update n_need_info set status=:status, statusName=:statusName where channelNeedNo=:BizId"
      var paramWhere = {
        statusName: '已跟进',
        status: 'ygj',
        BizId: actionBody.intentionBizId
      };
      var updateRes = await this.customUpdate(sql, paramWhere);
    }
    // 有需求单但没有沟通记录 直接set
    if (!needRes.followContent) {
      var sql = "update n_need_info set followContent=JSON_OBJECT(:followContent) where channelNeedNo=:BizId"
      var paramWhere = {
        followContent: actionBody.Note,
        BizId: actionBody.intentionBizId
      };
      var updateRes = await this.customUpdate(sql, paramWhere);
      if (updateRes[1]) {
        //2020-10-28 laolan  start
        var sql = "select uapp_id from n_need_info where channelNeedNo = :channelNeedNo ";
        var where = {
          channelNeedNo:actionBody.intentionBizId
        }
        var uappIdInfo = await this.customQuery(sql,where);
        console.log('uappIdInfo+++',uappIdInfo)
        if(uappIdInfo){
          var uappIds = uappIdInfo[0].uapp_id
        }
        return system.getResultSuccess(uappIds);
        //2020-10-28 laolan  end 
      }
      return system.getResult("添加记录失败");
      // 有需求单有沟通记录 json_array_append
    } else {
      var sql = "update n_need_info set followContent=json_array_append(followContent, '$', JSON_OBJECT(:Note)) where channelNeedNo=:BizId"
      // var sql = "update n_need_info set followContent=json_array_append(followContent, '$', "+ "\"" + JSON.stringify(actionBody.Note) + "\""+") where channelNeedNo="+ "\"" +actionBody.BizId +"\"" +"  "
      var paramWhere = {
        Note: actionBody.Note,
        BizId: actionBody.intentionBizId
      };
      var updateRes = await this.customUpdate(sql, paramWhere);
      if (updateRes[1]) {
        //2020-10-28 laolan  start
        var sql = "select uapp_id from n_need_info where channelNeedNo = :channelNeedNo ";
        var where = {
          channelNeedNo:actionBody.intentionBizId
        }
        var uappIdInfo = await this.customQuery(sql,where);
        if(uappIdInfo){
          var uappIds = uappIdInfo[0].uapp_id
        }
        return system.getResultSuccess(uappIds);
        //2020-10-28 laolan  end 
      }
      return system.getResult("添加记录失败");
    }
  }
  //2020-10-28 laolan 新增查询需求沟通记录
  async queryExpertApplyCommunicationLogs(pobj){
    console.log('query++pobj',pobj)
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100493");
    }
    if(pobj.appInfo.uapp_id == 18){
      if (!pobj.actionBody.userFeedBack) {
        return system.getResult(null, "actionBody.userFeedBack can not be empty，100494");
      }
    }
    var sql = "select uapp_id,followContent from n_need_info where channelNeedNo = :channelNeedNo ";
    var where = {
      channelNeedNo:pobj.actionBody.intentionBizId
    }
    var uappIdInfo = await this.customQuery(sql,where);
    if(uappIdInfo){
      uappIdInfo = uappIdInfo[0];
      return system.getResultSuccess(uappIdInfo);
    }
    
  }

  //2020-10-28 laolan 新增查询需求沟通记录
  async queryCommunicationLog(pobj){
    console.log('query++pobj',pobj)
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100493");
    }
    if(pobj.appInfo.uapp_id == 18){
      if (!pobj.actionBody.userFeedBack) {
        return system.getResult(null, "actionBody.userFeedBack can not be empty，100494");
      }
    }
    var sql = "select followContent from n_need_info where channelNeedNo = :channelNeedNo ";
    var where = {
      channelNeedNo:pobj.actionBody.intentionBizId
    }
    var uappIdInfo = await this.customQuery(sql,where);
    if(uappIdInfo){
      uappIdInfo = uappIdInfo[0];
      return system.getResultSuccess(uappIdInfo);
    }

  }

}
module.exports = NeedinfoService2;
