const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class PolicysubscribeService extends ServiceBase {
  constructor() {
    super("dbpolicy", ServiceBase.getDaoName(PolicysubscribeService));
    this.policyinfoDao = system.getObject("db.dbpolicy.policyinfoDao");
  }
  //提交政策订阅
  async submitPolicysubscribe(pobj){
    var app = pobj.appInfo;
    var obj = pobj.actionBody;
    var paramObj={uapp_id:app.uapp_id};
    if(!obj.openid){
      return system.getResult(null, "openid不能为空");
    }  
    if(!obj.policyProvince){
      return system.getResult(null, "policyProvince不能为空");
    }  
    if(!obj.policyTypes || obj.policyTypes.length<1){
      return system.getResult(null, "policyTypes不能为空");
    }
    paramObj["openid"] = obj.openid; 
    paramObj["policyProvince"] = obj.policyProvince; 
    paramObj["releaseDate"] = new Date(); 
    // ,policyTypes:{ [this.db.Op.like]: "%" + obj.policyName + "%" }
    // var oldsubscribe = await this.dao.model.findOne({
    //   where:{openid:obj.openid,policyProvince:obj.policyProvince},raw:true
    // });
    var policyTypes = "";
    policyTypes = obj.policyTypes[0];
    for(var i=1;i<obj.policyTypes.length;i++){
      var pt = obj.policyTypes[i];
      policyTypes = policyTypes+","+pt;
    }
    paramObj["policyTypes"] = policyTypes; 
    var policysubscribe = await this.dao.create(paramObj);
    // if(oldsubscribe && oldsubscribe.id){//存在某省份的订阅数据
    //   policyTypes = oldsubscribe.policyTypes;
    //   for(var i=0;i<obj.policyTypes.length;i++){
    //     var pt = obj.policyTypes[i];
    //     if(policyTypes.indexOf(pt)<0){
    //       policyTypes = policyTypes+","+pt;
    //     }
    //   }
    //   if(oldsubscribe.releaseDate){
    //     paramObj["releaseDate"]=oldsubscribe.releaseDate;
    //   }
    //   paramObj["policyTypes"] = policyTypes;
    //   paramObj["id"] = oldsubscribe.id;
    //   await this.dao.update(paramObj);
    // }else{//新的订阅数据
    //   policyTypes = obj.policyTypes[0];
    //   for(var i=1;i<obj.policyTypes.length;i++){
    //     var pt = obj.policyTypes[i];
    //     if(policyTypes.indexOf(pt)<0){
    //       policyTypes = policyTypes+","+pt;
    //     }
    //   }
    //   paramObj["policyTypes"] = policyTypes; 
    //   var policysubscribe = await this.dao.create(paramObj);
    // }
    return system.getResultSuccess();
  }
  //取消政策订阅
  async delPolicysubscribe(pobj){
    var app = pobj.appInfo;
    var obj = pobj.actionBody;
    var paramObj={uapp_id:app.uapp_id};
    if(!obj.openid){
      return system.getResult(null, "openid不能为空");
    }  
    if(!obj.policyId){
      return system.getResult(null, "policyId不能为空");
    }  
    await this.dao.delete({id:obj.policyId,openid:obj.openid,uapp_id:app.uapp_id});
    return system.getResultSuccess();
  }
  //获取政策订阅列表
  async getPolicysubscribeList(pobj){
    var app = pobj.appInfo;
    var obj = pobj.actionBody;
    var paramObj={uapp_id:app.uapp_id};
    if(!obj.openid){
      return system.getResult(null, "openid不能为空");
    }
    paramObj["openid"] = obj.openid;
    var resList = await this.dao.model.findAll({
      attributes:["id","policyProvince","policyTypes","created_at","releaseDate"],
      where:paramObj,raw:true,
      order:[["id", "DESC"]]
    });
    for(var i=0;i<resList.length;i++){
      var ps = resList[i];
      var whereObj = {uapp_id:app.uapp_id};
      if(ps.policyProvince && ps.policyProvince !="全国"){
        whereObj["policyProvince"] = ps.policyProvince;
      }
      if(ps.policyTypes){
        var types = ps.policyTypes.split(",");
        whereObj["policyType"] = { [this.db.Op.in]: types};
      }
      if(ps.releaseDate){
        whereObj["created_at"] = { [this.db.Op.gte]: ps.releaseDate};
      }
      var pis = await this.policyinfoDao.model.findAll({
        where:whereObj,raw:true,attributes:["id"]
      });
      ps.dataCount = pis?pis.length:0;
    }
    return system.getResultSuccess(resList);
  }
  //政策订阅检索列表
  async policySubscribeQuery(pobj){
    var app = pobj.appInfo;
    var obj = pobj.actionBody;
    if(!obj.openid){
      return system.getResult(null, "openid不能为空");
    }
    if(!obj.policySubscribeId){
      return system.getResult(null, "policySubscribeId不能为空");
    }
    var currentPage = obj.currentPage || 1;
    var pageSize = obj.pageSize || 100 ;
    var ps = await this.dao.model.findOne({
      where:{id:obj.policySubscribeId},
      raw:true
    });
    if(!ps || !ps.id){
      return system.getResult(null, "订阅信息不存在");
    }
    //{ where: { id: { [this.db.Op.in]: ids } } }
    var whereObj = {uapp_id:app.uapp_id};
    var attributes =["id","policyType","policyTypeName","policyDate","policyCity","policyProvince",
    "policyLinkUrl","policySource","policyName","policyNo"];
    if(ps.policyProvince  && ps.policyProvince !="全国"){
      whereObj["policyProvince"] = ps.policyProvince;
    }
    if(ps.policyTypes){
      var types = ps.policyTypes.split(",");
      whereObj["policyType"] = { [this.db.Op.in]: types};
    }
    if(ps.releaseDate){
      whereObj["created_at"] = { [this.db.Op.gte]: ps.releaseDate};
    }
    var pis = await this.policyinfoDao.model.findAll({//获取该订阅下的政策数据
      where:whereObj,raw:true,attributes:attributes,
      order:[["id", "DESC"]],
      offset:(currentPage - 1) * pageSize,
      limit:pageSize
    });
    if(!pis || pis.length<1){
      delete whereObj["created_at"];
      pis = await this.policyinfoDao.model.findAll({//获取该订阅下的政策数据
        where:whereObj,raw:true,attributes:attributes,
        order:[["id", "DESC"]],
        offset:(currentPage - 1) * pageSize,
        limit:pageSize
      });
    }
    var picount = await this.policyinfoDao.model.findAll({//获取该订阅下的政策数据
      where:whereObj,raw:true,attributes:["id"],
    });
    picount = picount.length;
    var res = system.getResultSuccess(pis);
    res.dataCount = picount;
    await this.dao.update({id:obj.policySubscribeId,releaseDate:new Date()});//修改订阅发布日期
    return res;
  }

}
module.exports = PolicysubscribeService;