//工商注册
const system = require("../../../system");
const moment = require('moment');
class RegCenterOrderService {
  constructor() {
    this.needsolutionDao = system.getObject("db.dbneed.needsolutionDao");
    this.needinfoDao = system.getObject("db.dbneed.needinfoDao");
    this.orderinfoDao = system.getObject("db.dbcorder.orderinfoDao");
    this.orderdeliveryDao = system.getObject("db.dbcorder.orderdeliveryDao");
    this.db = system.getObject("db.common.connection").getCon()

    //工商注册状态
    this.regSolutionStatus = {
      'RECEIVED': '已接单',
      'COLLECTING': '材料收集环节',
      'AUDITING': '工商审核环节',
      'ENGRAVING': '刻章环节',
      'SUCCESS': '已完成',
      'PAID': '已支付',
      "CLOSE": "已关闭",
      'ACTIVE': '服务中'
    };

    //工商注册状态
    this.regStatus = {
      'RECEIVED': 701,    //已接单
      'COLLECTING': 702,  //材料收集环节
      'AUDITING': 703,    //工商审核环节
      'ENGRAVING': 704,   //刻章环节
      'SUCCESS': 705,      //已完成
      'ACTIVE': 706        //服务中
    }

    this.regDeliveryStatus = {
      701: 'RECEIVED',    //已接单
      702: 'COLLECTING',  //材料收集环节
      703: 'AUDITING',    //工商审核环节
      704: 'ENGRAVING',   //刻章环节
      705: 'SUCCESS',      //已完成
      706: 'ACTIVE'         //服务中
    }

    this.regDeliveryStatusName = {
      701: '已接单',
      702: '材料收集环节',
      703: '工商审核环节',
      704: '刻章环节',
      705: '已完成',
      706: '服务中'
    }
  }

  // 获取需求详情
  async selectNeedInfo(pobj) {
    pobj.actionType = "selectNeedInfo"
    var needinfo = {}
    if (pobj.actionBody.orderNo) {
      var orderinfo = await this.orderinfoDao.findOne({ channelOrderNo: pobj.actionBody.orderNo, deleted_at: null });
      if (!orderinfo || !orderinfo.orderNo) {
        return system.getResult(null, "订单数据为空，30210");
      }
      var needsolution = await this.needsolutionDao.findOne({ orderNo: orderinfo.orderNo });
      if (!needsolution || !needsolution.channelSolutionNo) {
        return system.getResult(null, "方案数据为空，30211");
      }
      needinfo = await this.needinfoDao.findOne({ channelNeedNo: needsolution.channelNeedNo });
      if (!needinfo) {
        needinfo = {}
        needinfo['publishMobile'] = needsolution.solutionContent.customerInfo.publishMobile
        needinfo['channelNeedNo'] = needsolution.channelNeedNo
        needinfo['solutionContent'] = needsolution.solutionContent
      }
    }
    if (pobj.actionBody.channelNeedNo) {
      needinfo = await this.needinfoDao.findOne({ channelNeedNo: pobj.actionBody.channelNeedNo });
      if (!needinfo || !needinfo.channelNeedNo) {
        return system.getResult(null, "需求数据为空，30213");
      }
    }
    return system.getResultSuccess(needinfo);
  }

  //提交需求
  async submitRegNeed(pobj, actionBody, req) {
    var needNo = await this.getBusUid("n");
    if (!actionBody.intentionBizId) {
      return system.getResultFail(-5001, "intentionBizId不能为空");
    }
    if (!actionBody.mobile) {
      return system.getResultFail(-5002, "mobile不能为空");
    }
    if (!actionBody.type) {
      return system.getResultFail(-5003, "type不能为空");
    }
    var needInfo = await this.needinfoDao.findOne({ channelNeedNo: actionBody.intentionBizId });
    console.log('needInfo---', needInfo)
    if (needInfo) {
      return system.getResultSuccess(needInfo);
    }
    var nobj = {
      uapp_id: pobj.appInfo.uapp_id,
      channelNeedNo: actionBody.intentionBizId,
      needNo: needNo,
      channelUserId: actionBody.mobile,
      publishName: actionBody.userName,
      publishContent: actionBody.description,
      publishMobile: actionBody.mobile,
      city: actionBody.area || "",
      // disposeNotes: actionBody.ext,
      typeCode: actionBody.type_code,
      typeName: actionBody.type_name,
      channelTypeCode: actionBody.channel_type_code || "",
      channelTypeName: actionBody.channel_type_name || "",
      status: "wts",
      level: actionBody.level || "",
      probability: actionBody.probability || "",
      appName: actionBody.appName,
      serviceProductId: actionBody.service_product_id,
      notes: actionBody.notes || ""
    }
    // if (nobj.channelTypeCode == 7 || nobj.channelTypeCode == 5) {
    //   nobj.province = nobj.city, nobj.city = "";
    // }
    var needInfo = await this.needinfoDao.create(nobj);
    return system.getResultSuccess(needInfo);
  }

  //根据渠道订单获取方案信息
  async getSolutionByChannelOrderNo(pobj) {
    var orderinfo = await this.orderinfoDao.findOne({ channelOrderNo: pobj.actionBody.orderNo });
    if (!orderinfo || !orderinfo.orderNo) {
      return system.getResult(null, "订单数据为空，30210");
    }
    var item = await this.needsolutionDao.model.findOne({
      where: { orderNo: orderinfo.orderNo }
    });
    if (!item) {
      return system.getResult(null, "方案数据为空，30210");
    }
    return system.getResultSuccess(item);
  }
  //接收reg用户方案反馈
  async regFeedbackSubmit(pobj) {
    var ab = pobj.actionBody;
    if (!ab.intentionBizId) {
      return system.getResultFail(-101, "渠道需求编号错误");
    }
    if (!ab.description) {
      return system.getResultFail(-102, "问题描述不能为空");
    }
    if (!ab.hasOwnProperty("intentionStatus")) {
      return system.getResultFail(-103, "需求当前状态不能为空");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.intentionBizId }, raw: true
    });
    console.log('needinfo-----reg---', needinfo)
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    // if (needinfo.status == "ycd" || needinfo.status == "ygb") {
    if (needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findAll({
      where: { channelNeedNo: ab.intentionBizId, isInvalid: 0 }, raw: true
    });
    var intentionStatusList = ["未知", "⽅案待服务商确认", "⽅案待⽤户确认", "处理中", "已完成", "已关闭"];
    var updateObj = {};
    var solutionContent;
    var i;
    var nsLength
    var needData = { id: needinfo.id };
    if (ab.intentionStatus) {
      if (ab.intentionStatus == 5) {
        needData['status'] = 'ygb'
        needData['statusName'] = '已关闭'
      }
      if (ab.intentionStatus == 1) {
        needData["status"] = "ygb";
        needData['statusName'] = '已关闭'
      }
      if (ns.length < 1) {
        //如果没有方案直接关闭需求，更新需求状态
        await this.needinfoDao.update(needData);//更新状态修改
      }
      else {
        nsLength = ns.length
        for (i = 0; i < nsLength; i++) {
          updateObj = {
            id: ns[i].id
          };
          solutionContent = ns[i].solutionContent;
          solutionContent.customerRemark = ab.description;
          solutionContent.needStatus = ab.intentionStatus;
          if (ab.intentionStatus == 1) {
            updateObj["status"] = "ybh";
            updateObj["isInvalid"] = 1;
          } else if (ab.intentionStatus == 2) {
            updateObj["status"] = "dqr";
          } else if (ab.intentionStatus == 3) {
            updateObj["status"] = "dqr";
          } else if (ab.intentionStatus == 4) {
            updateObj["status"] = "dqr";
          } else if (ab.intentionStatus == 5) {
            updateObj["status"] = "yzf";
            updateObj["isInvalid"] = 1;
          } else {
            return system.getResultFail(-107, "需求当前状态错误--" + ab.intentionStatus);
          }
          solutionContent.needStatusName = intentionStatusList[ab.intentionStatus];
          solutionContent = JSON.stringify(solutionContent);
          updateObj["solutionContent"] = solutionContent;
          await this.needsolutionDao.update(updateObj);//方案状态修改
          await this.needinfoDao.update(needData);//更新状态修改
        }
      }
    }
    return system.getResultSuccess();
  }
  //添加业务员信息，用于直接下单的reg订单
  async addRegSalesmanInfo(pobj) {
    var ab = pobj.actionBody;
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    var salesmanObj = ab.salesmanInfo;
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: ab.orderNo, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var solutionContent = ns.solutionContent;
    solutionContent.salesmanInfo = salesmanObj;
    var updateObj = { id: ns.id, solutionContent: JSON.stringify(solutionContent) }
    await this.needsolutionDao.update(updateObj);//方案状态修改
    return system.getResultSuccess(solutionContent);
  }

  //渠道方案号获取需求详情
  async getItemByChannelSolutionNo(pobj) {
    console.log('getItemByChannelSolutionNo---', pobj)
    var solutionitem = {}
    var orderinfo = {}
    var item = {}
    if (pobj.actionBody.channelSolutionId) {
      solutionitem = await this.needsolutionDao.findOne({ channelSolutionNo: pobj.actionBody.channelSolutionId });
      console.log('solutionitem---', solutionitem)
      if (!solutionitem) {
        return system.getResult(null, "方案数据为空，30210");
      }
    }
    if (pobj.actionBody.orderNo) {
      orderinfo = await this.orderinfoDao.findOne({ channelOrderNo: pobj.actionBody.orderNo });
      if (orderinfo) {
        solutionitem = await this.needsolutionDao.findOne({ orderNo: orderinfo.orderNo });
      }
    }
    item = await this.needinfoDao.getItemByNeedNo(solutionitem.needNo);
    if (!item && !solutionitem) {
      return system.getResult(null, "需求或者方案不存在,30211");
    }

    if (!item) {
      item = {}
      item['publishMobile'] = solutionitem.solutionContent.customerInfo.publishMobile
      item['solutionProvince'] = solutionitem.solutionContent.solution.area;
      item['solutionContent'] = solutionitem.solutionContent
      item['channelSolutionNo'] = solutionitem.channelSolutionNo
    } else {
      item.solutionProvince = solutionitem.solutionContent.solution.area;
      item.solutionContent = solutionitem.solutionContent
      item.channelSolutionNo = solutionitem.channelSolutionNo
    }

    return system.getResultSuccess(item);
  }

  //接收渠道方案状态变更通知
  async regOrderStatus(pobj) {
    var ab = pobj.actionBody;
    if (!ab.BizId) {
      return system.getResultFail(-101, "渠道方案号不能为空");
    }
    if (!ab.status) {
      return system.getResultFail(-102, "方案状态不能为空");
    }
    if (ab.isDirectBuy && ab.isDirectBuy == 1 && ab.status == 1) {//直接下单，无方案 直接返回
      return system.getResultSuccess(pobj);
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { channelSolutionNo: ab.channelSolutionId, isInvalid: 0 }, raw: true
    });
    if (!ns) {
      return system.getResultFail(-102, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var solutionContent = ns.solutionContent;
    var checkStatus = {
      COLLECTING: "材料收集环节", AUDITING: "工商审核环节", ACTIVE: "服务中",
      ENGRAVING: "刻章环节", SUCCESS: "已完成", CLOSE: "方案关闭"
    };
    if (solutionContent.status && checkStatus[solutionContent.status]) {
      return system.getResultFail(-111, "方案已进入" + solutionContent.statusName + "流程，不能执行此操作");
    }
    //方案流程列表
    var solutionFlowList = solutionContent.solutionFlowList || [];
    if (ab.status == "1") {//⽤户已支付
      var afterStatusList = [//用户支付后的流程状态
        "COLLECTING", "AUDITING", "ENGRAVING", "SUCCESS"
      ];
      if (!solutionContent.status || afterStatusList.indexOf(solutionContent.status) < 0) {
        solutionFlowList.push({
          status: "PAID", statusName: this.regSolutionStatus.PAID, updated_at: new Date()
        });
        solutionContent.status = "PAID";
        solutionContent.statusName = this.regSolutionStatus.PAID;
      }
      //修改 n_need_info status为ycd 已成单
      let needObj = {
        id: needinfo.id, status: "ycd"
      }
      await this.needinfoDao.update(needObj);//关闭需求
    } else if (ab.status == "4") {//材料收集
      if (solutionContent.status == "COLLECTING") {
        return system.getResultFail(-112, "操作失败，材料已收集");
      }
      solutionFlowList.push({
        status: "COLLECTING", statusName: this.regSolutionStatus.COLLECTING, updated_at: new Date()
      });
      solutionContent.status = "COLLECTING";
      solutionContent.statusName = this.regSolutionStatus.COLLECTING;
    } else if (ab.status == "AUDITING") {//工商审核
      if (solutionContent.status != "COLLECTING") {
        return system.getResultFail(-113, "操作失败，材料收集环节后才能执行此操作");
      }
      solutionFlowList.push({
        status: "AUDITING", statusName: this.regSolutionStatus.AUDITING, updated_at: new Date()
      });
      solutionContent.status = "AUDITING";
      solutionContent.statusName = this.regSolutionStatus.AUDITING;
    } else if (ab.status == "CLOSE") {//⽅案已关闭
      solutionFlowList.push({
        status: "CLOSE", statusName: this.regSolutionStatus.CLOSE, updated_at: new Date()
      });
      solutionContent.status = "CLOSE";
      solutionContent.statusName = this.regSolutionStatus.CLOSE;
    } else {
      return system.getResultFail(-110, "状态错误-5");
    }
    solutionContent.solutionFlowList = solutionFlowList;

    var material = solutionContent.customerMaterial || {};
    if (ab.remark) {
      solutionContent.customerRemark = ab.remark;
    }
    if (ab.newbusinessLicense) {
      material.businessLicense = ab.newbusinessLicense;
      material.aliBusinessLicense = ab.businessLicense;
    }
    if (ab.newidCardUrlList && ab.newidCardUrlList.length > 0) {
      material.idCardUrlList = ab.newidCardUrlList;
      material.aliIdCardUrlList = ab.idCardUrlList;
    }
    if (ab.newuserPlan) {
      material.userPlan = ab.newuserPlan;
      material.aliUserPlan = ab.userPlan;
    }
    if (ab.newuserForeig) {
      material.userForeig = ab.newuserForeig;
      material.aliUserForeig = ab.userForeig;
    }
    if (ab.newuserLaw) {
      material.userLaw = ab.newuserLaw;
      material.aliUserLaw = ab.userLaw;
    }
    if (ab.newuserOtherList && ab.newuserOtherList.length > 0) {
      material.userOtherList = ab.newuserOtherList;
      material.aliUserOtherList = ab.userOtherList;
    }
    solutionContent.customerMaterial = material;
    solutionContent = JSON.stringify(solutionContent);
    var updateObj = {
      id: ns.id, solutionContent: solutionContent
    };
    if (ab.status == "CLOSE") {//⽅案已关闭
      updateObj["status"] = "yzf";
      updateObj["isInvalid"] = 1;
    }
    await this.needsolutionDao.update(updateObj);//方案状态修改
    var new_ns = await this.needsolutionDao.model.findOne({
      where: { id: ns.id }, raw: true
    });
    return system.getResultSuccess(new_ns);
  }

  //接收方案状态及支付信息
  async regReceiveSolutionPayInfo(pobj) {
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    if (!ab.channelSolutionNo) {
      return system.getResultFail(-101, "渠道方案编号不能为空");
    }
    if (ab.isDirectBuy && ab.isDirectBuy == 1) {//直接下单
      var oldNs = await this.orderinfoDao.model.findOne({
        where: { orderNo: ab.orderNo }, raw: true
      });
      var newNsObj = {
        orderNo: ab.orderNo, channelSolutionNo: ab.channelSolutionNo, solutionNo: ab.channelSolutionNo,
        needNo: ab.bizId, channelNeedNo: ab.bizId, status: "ywc"
      };
      var newSolutionCount = {
        "status": "PAID",
        "bizType": ab.product_info && ab.product_info.item_code ? ab.product_info.item_code : "",
        "companyName": ab.companyName || "",
        "engagedIndustry": ab.engagedIndustry || "",
        "bizScope": ab.bizScope || "",
        "hasAddress": ab.hasAddress || "",
        "solution": {
          // companyName：公司名称
          // engagedIndustry：从事行业
          // bizScope：经营范围
          // hasAddress：是否自有地址，布尔值
          companyName: ab.companyName || "",
          engagedIndustry: ab.engagedIndustry || "",
          bizScope: ab.bizScope || "",
          hasAddress: ab.hasAddress || "",
          area: ab.area || "",
          price: ab.orderPrice || "",
          regType: ab.consultType || "",
          taxpayerType: ab.taxpayerType || "",
          companyProperties: ab.companyProperties || ""
        },
        "totalSum": ab.totalSum || "",
        "typeCode": ab.product_info && ab.product_info.item_code ? ab.product_info.item_code : "",
        "typeName": ab.product_info && ab.product_info.item_name ? ab.product_info.item_name : "",
        "needStatus": "3",
        "statusName": "用户支付",
        "customerInfo": {
          "publishName": pobj.userInfo.channel_nickname || "",
          "publishMobile": pobj.userInfo.mobile || ""
        },
        "customerRemark": ab.description || "",
        "needStatusName": "处理中",
        "customerMaterial": {},
        "solutionFlowList": [
          {
            "status": "PAID",
            "statusName": "用户支付",
            "updated_at": new Date()
          }
        ]
      };
      newNsObj.solutionContent = JSON.stringify(newSolutionCount);
      var ns = null;
      // if(oldNs && oldNs.id){
      //   ns = oldNs;
      //   console.log('ddddddd---ns=====',ns)
      // }else{
      ns = await this.needsolutionDao.create(newNsObj);
      // }
      var ns2 = await this.needsolutionDao.model.findOne({
        where: { id: ns.id }, raw: true
      });
      return system.getResultSuccess(ns2);
    } else {
      var needsolutioninfo = await this.needsolutionDao.model.findOne({
        attributes: ["id", "solutionContent", "status", "orderNo"],
        where: { channelSolutionNo: ab.channelSolutionId, isInvalid: 0 }, raw: true
      });
      if (!needsolutioninfo || !needsolutioninfo.id) {
        return system.getResultFail(-400, "未知方案");
      }
      var solutionContent = needsolutioninfo.solutionContent;
      if (ab.orderPrice) {
        // solutionContent = JSON.parse(solutionContent);
        solutionContent["totalSum"] = Number(ab.orderPrice || "0");
      }
      if (ab.orderNo) {
        needsolutioninfo.orderNo = ab.orderNo;
        needsolutioninfo.status = "ywc";
      }
      needsolutioninfo.solutionContent = JSON.stringify(solutionContent);
      await this.needsolutionDao.update(needsolutioninfo);
      var ns = await this.needsolutionDao.model.findOne({
        where: { id: needsolutioninfo.id }, raw: true
      });
      return system.getResultSuccess(ns);
    }

  }

  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }


  //关闭订单
  async regOrderClose(pobj) {
    var ab = pobj.actionBody;
    if (!ab.orderNo) {
      return system.getResultFail(-101, "渠道订单号不能为空");
    }
    var orderInfo = await this.orderinfoDao.model.findOne({
      where: { channelOrderNo: ab.orderNo }, raw: true
    });
    if (!orderInfo || !orderInfo.id) {
      return system.getResultFail(-103, "未知订单");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: orderInfo.orderNo, isInvalid: 0 }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-102, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns.needNo }, raw: true
    });
    var solutionContent = ns.solutionContent;
    var checkStatus = {
      COLLECTING: "材料收集环节", AUDITING: "工商审核环节",
      ENGRAVING: "刻章环节", SUCCESS: "已完成"
    };
    if (solutionContent.status && checkStatus[solutionContent.status]) {
      return system.getResultFail(-111, "方案已进入" + solutionContent.statusName + "流程，不能执行此操作");
    }
    //方案流程列表
    var solutionFlowList = solutionContent.solutionFlowList || [];
    solutionFlowList.push({
      status: "CLOSE", statusName: this.regSolutionStatus.CLOSE, updated_at: new Date()
    });
    solutionContent.status = "CLOSE";
    solutionContent.statusName = this.regSolutionStatus.CLOSE;
    solutionContent.solutionFlowList = solutionFlowList;
    if (ab.remark) {
      solutionContent.customerRemark = ab.remark;
    }
    solutionContent = JSON.stringify(solutionContent);
    var updateObj = {
      id: ns.id, solutionContent: solutionContent, status: "yzf", isInvalid: 1
    };
    var self = this;
    return await this.needsolutionDao.db.transaction(async function (t) {
      await self.needsolutionDao.update(updateObj);//方案状态修改
      await self.orderinfoDao.update({ id: orderInfo.id, orderStatus: 16 });//订单状态修改
      var new_ns = await self.needsolutionDao.model.findOne({
        where: { id: ns.id }, raw: true
      });
      return system.getResultSuccess(new_ns);
    })

  }

  //------------3.
  //提交方案 yiwancheng
  async regSubmitSolution(pobj) {
    console.log("pobj++submitRegSolution++", pobj)
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.needNo) {
      return system.getResultFail(-101, "渠道需求号不能为空");
    }
    var i;
    var j;
    var k;
    var l;
    var solutionType = [];
    var solutionContent;
    var needsolutions = [];//最后返回结果用
    var bizType = [];//业务类型 百度公司注册兼容公司注册套餐
    if (ab.solutionList) {
      var solutionListLength = ab.solutionList.length;
    }
    console.log('ab.solutionList------', ab.solutionList)
    for (i = 0; i < solutionListLength; i++) {
      if (!ab.solutionList[i].solutionContent) {
        return system.getResultFail(-102, "方案信息有误");
      }
      solutionContent = ab.solutionList[i].solutionContent
      solutionType.push(solutionContent.solution.regType)
      console.log('solutionType------', solutionType)
      bizType.push(solutionContent.solution.regType)
    }
    bizType = bizType.toString()
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能创建方案");
    }
    // var bizType = needinfo.typeCode;//业务类型 原百度公司注册

    if (!bizType) {
      return system.getResultFail(-205, "方案类型错误");
    }
    if (!needinfo.channelTypeCode) {
      return system.getResultFail(-206, "渠道方案类型错误");
    }

    //查询对应类型方案是否有提交，提交过的不能重复提交
    var ns = await this.needsolutionDao.model.findAndCountAll({
      where: { channelNeedNo: ab.needNo }, raw: true, order: [["id", 'asc']]
    });
    console.log('ns----', ns)
    var nsRegType = [];
    if (ns) {
      var nsLength = ns.rows.length;
      for (l = 0; l < nsLength; l++) {
        if (ns.rows[l].isInvalid == 0) {
          nsRegType.push(ns.rows[l].solutionContent.solution.regType)
        }
        if (ns.rows[l].isInvalid == 1 && !ns.rows[l].solutionContent.solution.channelSolutionNo && ns.rows[l].status == "ybh") {
          return system.getResultFail(-207, "该方案中包含已驳回方案，不能新建方案，只能修改方案");
        }
      }

      var diff;
      diff = nsRegType.find(item => solutionType.includes(item))
      console.log('diff---', diff)
      if (diff != undefined) {
        return system.getResultFail(-208, "该方案中包含已提交过的方案，不能重复提交");
      }
    }
    for (j = 0; j < solutionListLength; j++) {
      if (ab.solutionList[j].solutionContent) {
        ab.solutionList[j].solutionContent.bizType = bizType;
        ab.solutionList[j].solutionContent.typeCode = bizType;
        // ab.solutionList[j].solutionContent.typeName = needinfo.typeName;//需求类型中文 原百度公司注册
        switch (bizType) {
          case "GSREG":
            ab.solutionList[j].solutionContent.typeName = needinfo.typeName
            break;
          case "QYJYTC1":
            ab.solutionList[j].solutionContent.typeName = "企业经营套餐一"
            break;
          case "QYJYTC2":
            ab.solutionList[j].solutionContent.typeName = "企业经营套餐二"
            break;
        }
        for (k = 0; k < ns.rows.length; k++) {
          var fa = ns.rows[k];
          // if (fa.status == "dqr" || fa.status == "ywc") {
          //   return system.getResultFail(-207, "需求方案已存在，不能重复提交");
          // }
          if (fa.status == "ybh") {
            ab.solutionList[j].channelSolutionNo = fa.channelSolutionNo;
          }
          if (fa.status == "yzf") {
            ab.solutionList[j].channelSolutionNo = "";
          }
        }

        var solutionFlowList = ab.solutionList[j].solutionContent.solutionFlowList || [];
        solutionFlowList.push({
          status: "RECEIVED", statusName: this.regSolutionStatus.RECEIVED, updated_at: new Date()
        });
        ab.solutionList[j].solutionContent.status = "RECEIVED";
        ab.solutionList[j].solutionContent.statusName = this.regSolutionStatus.RECEIVED;
        ab.solutionList[j].solutionContent.solutionFlowList = solutionFlowList;
        ab.solutionList[j]["channelNeedNo"] = needinfo.channelNeedNo;
        var solutionNo = [];//chuangjian
        solutionNo[j] = await this.getBusUid("ns")
        console.log('solutionNo[j]----', solutionNo[j])
        ab.solutionList[j]["solutionNo"] = solutionNo[j];
        ab.solutionList[j]["status"] = "dqr";
        var customerInfo = {//客户信息
          "publishName": needinfo.publishName,
          "publishMobile": needinfo.publishMobile
        };
        var salesmanInfo = {//业务员信息
          "salesmanName": user.channel_username,
          "salesmanMobile": user.mobile,
          "salesmanId": user.id,
          "salesmanChannelId": user.channel_userid
        };
        ab.solutionList[j].solutionContent["customerInfo"] = customerInfo;
        ab.solutionList[j].solutionContent["salesmanInfo"] = salesmanInfo;
        ab.solutionList[j].solutionContent.solution.price = (ab.solutionList[j].solutionContent.solution.price) / 100 || "";//分转元
        ab.solutionList[j].solutionContent = JSON.stringify(ab.solutionList[j].solutionContent);
        console.log('abababab---+++---++', ab)
        var self = this;
        await this.needsolutionDao.db.transaction(async function (t) {
          ab.solutionList[j]["needNo"] = needinfo.needNo;
          var od = await self.needsolutionDao.create(ab.solutionList[j], t);
          if (od && od.id) {
            var needObj = {
              id: needinfo.id
            };
            if (!needinfo.followManUserId) {
              needObj = {
                id: needinfo.id,
                followManUserId: user.id,//跟进人id
                followManName: user.channel_username,//跟进人姓名
                followManMobile: user.mobile,//跟进人手机号（合伙人）
                followManOnlyCode: user.channel_userid
              };
            }
            if (!needinfo.followContent) {
              var followContent = [{
                followDate: new Date(),
                content: "reg提交方案"
              }];
              followContent = JSON.stringify(followContent);
              needObj["followContent"] = followContent;
            }
            await self.needinfoDao.update(needObj, t);
            needinfo = await self.needinfoDao.model.findOne({
              where: { id: needinfo.id }, raw: true
            });
            needsolutions.push(od.dataValues)
            console.log('needsolutions-------', needsolutions)
          }
        })
      }
    }
    return system.getResultSuccess({ needinfo: needinfo, needsolutions: needsolutions });
  }

  //方案更新
  async updateSolution(pobj) {
    console.log("pobj++updateSolution++", pobj)
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    ab["createUserId"] = user.id;
    if (!ab.needNo) {
      return system.getResultFail(-101, "渠道需求号不能为空");
    }

    var needsolutions = [];//最后返回结果用

    console.log('ab.solutionList------', ab.solutionList)
    if (!ab.solutionList[0].solutionContent) {
      return system.getResultFail(-102, "方案信息有误");
    }
    if (!ab.solutionList[0].solutionContent.solution.channelSolutionNo) {
      return system.getResultFail(-103, "渠道方案号不能为空");
    }

    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: ab.needNo }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-104, "未知需求信息");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "修改方案,该方案需求状态为" + needinfo.statusName + ",不能创建方案");
    }
    var bizType = needinfo.typeCode;//业务类型
    if (!bizType) {
      return system.getResultFail(-106, "修改方案,方案类型错误");
    }
    if (!needinfo.channelTypeCode) {
      return system.getResultFail(-107, "修改方案,渠道方案类型错误");
    }

    //查询对应类型方案是否有驳回，驳回后直接更新
    var bhns = await this.needsolutionDao.model.findOne({
      where: { channelSolutionNo: ab.solutionList[0].solutionContent.solution.channelSolutionNo, isInvalid: 1, status: "ybh" }, raw: true, order: [["id", 'asc']]
    });
    console.log('bhns----', bhns)
    if (!bhns) {
      return system.getResultFail(-108, "修改方案,不存在的驳回方案");
    } else {
      var self = this
      ab.solutionList[0].solutionContent = JSON.stringify(ab.solutionList[0].solutionContent);
      await this.needsolutionDao.db.transaction(async function (t) {
        ab.solutionList[0]["status"] = "dqr";
        ab.solutionList[0]["statusName"] = "待确认";
        ab.solutionList[0]["isInvalid"] = 0;
        var jsonDatas = ab.solutionList[0].solutionContent
        var jsonData = JSON.parse(jsonDatas)
        var od = await self.needsolutionDao.updateByWhere(ab.solutionList[0], { where: { channelSolutionNo: jsonData.solution.channelSolutionNo } }, t);
        console.log("od-----", od)
        if (od && od.length > 0) {
          var needObj = {
            id: needinfo.id,
            followManUserId: user.id,//跟进人id
            followManName: user.channel_username,//跟进人姓名
            followManMobile: user.mobile,//跟进人手机号（合伙人）
            followManOnlyCode: user.channel_userid
          };
          var followContent = [{
            followDate: new Date(),
            content: "驳回后更新方案"
          }];
          followContent = JSON.stringify(followContent);
          needObj["followContent"] = followContent;
          await self.needinfoDao.update(needObj, t);
          needinfo = await self.needinfoDao.model.findOne({
            where: { id: needinfo.id }, raw: true
          });
          needsolutions.push(bhns)
          console.log('needsolutions-------', needsolutions)
        }
      })
    }
    return system.getResultSuccess({ needinfo: needinfo, needsolutions: needsolutions });
  }
  //方案推送baidu后,接收保存方案编号/链接
  async saveReginfo(pobj) {
    console.log('----pobj--', pobj)
    var ab = pobj.actionBody;
    console.log('---ab---', ab)
    if (!ab.infos) {
      return system.getResultFail(-101, "渠道信息不能为空");
    }
    var i;
    var j;
    var infosLength = ab.infos.length
    var solutionNos = [];
    var infoList = [];
    for (i = 0; i < infosLength; i++) {
      solutionNos.push(ab.infos[i].gsbBizId)
    }
    console.log('----solutionNos----', solutionNos)
    var ns = await this.needsolutionDao.model.findAll({
      where: { solutionNo: { [this.db.Op.in]: solutionNos }, isInvalid: 0 }, raw: true
    });
    console.log("----ns----", ns)
    var nsLength = ns.length
    if (!ns) {
      return system.getResultFail(-103, "未知方案");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { needNo: ns[0].needNo }, raw: true
    });
    if (!needinfo) {
      return system.getResultFail(-104, "未知方案需求");
    }
    if (needinfo.status == "ycd" || needinfo.status == "ygb") {
      return system.getResultFail(-105, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    var confirmUrl = []
    var str;
    for (j = 0; j < nsLength; j++) {
      confirmUrl.push(ab.infos[j].confirmUrl)
      ns[j].solutionContent['confirmUrl'] = ab.infos[j].confirmUrl
      str = ns[j].solutionContent
      str = JSON.stringify(str)
      await this.needsolutionDao.model.update({ channelSolutionNo: ab.infos[j].bizId, solutionContent: str }, { where: { id: ns[j].id } });//修改方案信息
    }
    return system.getResultSuccess();
  }

  //回写沟通记录
  async regWriteCommunicationLog(pobj) {
    console.log('回写沟通记录----pobj------', pobj)
    // 查询需求沟通记录
    pobj.actionBody.Note = ["noteTime", moment().format("YYYY-MM-DD HH:mm:ss"), "note", pobj.actionBody.note];
    let needRes = await this.needinfoDao.findOne({ channelNeedNo: pobj.actionBody.intentionBizId });
    console.log('回写沟通记录----needRes------', needRes)
    var uappIds
    // 没有需求单直接返回
    if (!needRes) {
      return system.getResult("没有这个需求单");
    } else {
      uappIds = needRes.uapp_id
    }
    // 如果未推送/以推送 修改为已跟进
    if (needRes.status == "wts" || needRes.status == "yts") {
      var paramWhere = {
        statusName: '已跟进',
        status: 'ygj'
      };
      var updateRes = await this.needinfoDao.updateByWhere(paramWhere, { where: { channelNeedNo: pobj.actionBody.intentionBizId } });
      console.log('回写沟通记录----updateRes---', updateRes)
    }
    // 有需求单但没有沟通记录 直接set
    if (!needRes.followContent) {
      var paramWhere = {
        followContent: pobj.actionBody.Note
      };
      var updateRes = await this.needinfoDao.updateByWhere(paramWhere, { where: { channelNeedNo: pobj.actionBody.intentionBizId } });
      console.log('回写沟通记录----updateRes---updateRes---', updateRes)
      // 有需求单有沟通记录 json_array_append
    } else {
      var paramWhere = {
        Note: pobj.actionBody.Note
      };
      var updateRes = await this.needinfoDao.updateByWhere(paramWhere, { where: { channelNeedNo: pobj.actionBody.intentionBizId } });
      console.log('updateRes------', updateRes)
    }
    return system.getResultSuccess(uappIds);
  }
  //新增查询需求沟通记录
  async regQueryExpertCommunicationLogs(pobj) {
    console.log('query++pobj', pobj)
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100493");
    }
    var needinfo = await this.needinfoDao.model.findOne({
      where: { channelNeedNo: pobj.actionBody.intentionBizId }, raw: true
    });
    if (needinfo) {
      return system.getResultSuccess(needinfo);
    }
  }

  //根据需求关闭reg需求/方案
  async regNeedClose(pobj) {
    console.log("regNeedClose+++", pobj)
    var ab = pobj.actionBody;
    var app = pobj.appInfo;
    var uappId;
    if (!app || !app.uapp_id) {
      return system.getResultFail(-100, "未知渠道");
    }
    if (!ab.intentionBizId) {
      return system.getResultFail(-101, "需求编号不能为空");
    }
    //获取需求信息
    var needinfo = await this.needinfoDao.model.findOne({
      attributes: ["id", "status", "statusName", "needNo", "uapp_id"],
      where: { channelNeedNo: ab.intentionBizId }, raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-201, "未知需求信息");
    } else {
      uappId = needinfo.uapp_id
    }
    if (needinfo.status == "ygb" || needinfo.status == "ycd") {
      return system.getResultFail(-202, "该方案需求状态为" + needinfo.statusName + ",不能执行此操作");
    }
    //获取方案信息
    var ns = await this.needsolutionDao.model.findAndCountAll({
      where: { needNo: needinfo.needNo, isInvalid: 0 }, raw: true
    });
    console.log('nnnsss-----', ns)
    var i;
    var needObj = {};
    var updateSolution = {}
    var nsLength = ns.rows.length
    if (nsLength > 0) {
      for (i = 0; i < nsLength; i++) {
        if (ns.rows[i].orderNo) {
          return system.getResultFail(-102, "该需求已生成订单，不能关闭！");
        }
        if (ns.rows[i].id) {
          ns.rows[i]['uapp_id'] = uappId;
          if (ns.rows[i].status == "ywc") {
            return system.getResultFail(-103, "方案状态错误，不能废弃" + ns.rows[i].statusName + "方案");
          }
          var flowStatus = ns.rows[i].solutionContent && ns.rows[i].solutionContent.status ? ns.rows[i].solutionContent.status : "";

          if (flowStatus && ["SUCCESS"].indexOf(flowStatus) == 0) {
            return system.getResultFail(-104, "方案状态为已完成，不能关闭需求");
          }
          var self = this
          updateSolution = {
            status: "yzf",
            isInvalid: 1
          }
          await this.needsolutionDao.db.transaction(async function (t) {
            needObj = {
              status: "ygb", notes: ab.note
            };
            await self.needinfoDao.updateByWhere(needObj, { where: { id: needinfo.id }, t });//关闭需求
            var a = await self.needsolutionDao.updateByWhere(updateSolution, { where: { id: ns.rows[i].id }, t });//方案废弃
            console.log("aaaa---", a)
          })
          return system.getResultSuccess(ns);
        }
      }
    } else {
      needObj = {
        id: needinfo.id, status: "ygb", notes: ab.note
      };
      await this.needinfoDao.updateByWhere(needObj, { where: { id: needinfo.id } })
      return system.getResultSuccess(needinfo);
    }
  }

  //交付商通知状态变更
  async regUpdateOrderStatus(pobj) {
    var ab = pobj.actionBody;
    if (!ab.consultType) {
      return system.getResultFail(-101, "业务大类不能为空");
    }
    if (ab.consultType == "QYJYTC1" || ab.consultType == "QYJYTC2") {
      if (!ab.productType) {
        return system.getResultFail(-101, "业务小类不能为空");
      }
    }
    if (!ab.orderNo) {
      return system.getResultFail(-101, "订单号不能为空");
    }
    if (!ab.status) {
      return system.getResultFail(-102, "交付状态不能为空");
    } else {
      ab["ApplicationStatus"] = ab.status;
    }
    if (ab.officialFileURL) {
      ab["OfficialFileURL"] = ab.officialFileURL;
    }
    if (pobj.deliverContent) {
      ab['deliverContent'] = ab.deliverContent
    }
    var ns = await this.needsolutionDao.model.findOne({
      where: { orderNo: ab.orderNo }, raw: true
    });
    var od = await this.orderinfoDao.model.findOne({
      where: { orderNo: ab.orderNo }, raw: true
    });
    if (!ns || !ns.id) {
      return system.getResultFail(-301, "未知方案");
    }
    ab["bizId"] = od.channelOrderNo;
    // ab["bizId"] = ns.channelSolutionNo;
    ab["solutionNo"] = ns.solutionNo;
    pobj.actionBody = ab;
    return await this.regAcceptPartnerNotification(pobj);
  }
  //服务商通知状态变更
  async regAcceptPartnerNotification(pobj) {
    console.log('服务商通知状态变更pobj++++', pobj)
    var ab = pobj.actionBody;
    var user = pobj.userInfo;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!ab.solutionNo) {
      return system.getResultFail(-101, "方案编号不能为空");
    }
    if (!ab.ApplicationStatus) {
      return system.getResultFail(-102, "通知状态不能为空");
    }
    var deliveryContents;
    if (ab.deliverContent) {
      deliveryContents = ab.deliverContent
    }
    //获取方案信息
    var needsolutioninfo = await this.needsolutionDao.model.findOne({
      attributes: ["id", "status", "solutionContent", "needNo"],
      where: { solutionNo: ab.solutionNo }, raw: true
    });
    if (!needsolutioninfo || !needsolutioninfo.id) {
      return system.getResultFail(-400, "未知方案");
    }
    if (!needsolutioninfo.needNo) {
      return system.getResultFail(-401, "方案需求信息有误");
    }
    //获取交付信息 原始公司注册 start
    let bizTypeName
    let productType = ab.productType
    let orderdeliverySqlData = {
      sourceOrderNo: ab.orderNo
    }
    let orderdeliverySql = "SELECT * FROM `c_order_delivery` WHERE sourceOrderNo = :sourceOrderNo  ORDER BY id DESC limit 1";
    let orderdeliveryInfo = await this.orderdeliveryDao.customQuery(orderdeliverySql, orderdeliverySqlData)
    let solutionFlowList = [];
    var deliveryFlowList = [];
    let deliveryContent = {};
    var applicationStatusList

    var orderInfo = await this.orderinfoDao.model.findOne({
      attributes: ["uapp_id", "channelOrderNo"],
      where: { orderNo: ab.orderNo }, raw: true
    })
    console.log("orderInfo+++", orderInfo)
    if (orderInfo) {
      var uappId = orderInfo.uapp_id;
      var channelOrderNo = orderInfo.channelOrderNo
    }
    let startTime
    let endTime
    if (ab.startTime) {
      startTime = (new Date(ab.startTime * 1000)).Format("yyyy-MM-dd hh:mm:ss")
    }
    if (ab.startTime) {
      endTime = (new Date(ab.endTime * 1000)).Format("yyyy-MM-dd hh:mm:ss")
    }
    if (ab.consultType == "QYJYTC1") {
      bizTypeName = "企业经营套餐一"
    }
    if (ab.consultType == "QYJYTC2") {
      bizTypeName = "企业经营套餐二"
    }
    //判断是否有交付信息
    if (orderdeliveryInfo[0] && orderdeliveryInfo[0].deliveryContent) {
      deliveryContent = orderdeliveryInfo[0].deliveryContent;
      //判断大类是否是套餐
      if (ab.consultType && ab.consultType == "GSREG") {//非套餐
        if (deliveryContent && deliveryContent.status && deliveryContent.ApplicationStatus && deliveryContent.solutionFlowList) {
          // if (this.regStatus[deliveryContent.status] && this.regStatus[deliveryContent.status] > ab.ApplicationStatus) {
          //   return system.getResultFail(-403, "操作失败，交付流程未按顺序执行");
          // }
          if (this.regStatus[deliveryContent.ApplicationStatus] && this.regStatus[deliveryContent.ApplicationStatus] == ab.ApplicationStatus && ab.ApplicationStatus == 705) {
            return system.getResultFail(-405, "操作失败，该方案已完成，不能更改");
          }
          if (ab.ApplicationStatus == 702) {//材料收集环节
            if (needsolutioninfo.solutionContent.status != "PAID") {
              return system.getResultFail(-702, "交付流程错误，请先完成支付");
            }
            deliveryContent['ApplicationStatus'] = 702;
            solutionFlowList.push({
              file: ab.OfficialFileURL || "",
              status: "COLLECTING", statusName: this.regSolutionStatus.COLLECTING, updated_at: new Date()
            });
            deliveryContent.status = "COLLECTING";
            deliveryContent.statusName = this.regSolutionStatus.COLLECTING;
          }
          if (ab.ApplicationStatus == 703) {//工商审核环节
            var afterStatusList = [//用户支付后的流程状态
              "COLLECTING", "AUDITING", "ENGRAVING", "SUCCESS"
            ];
            if (!deliveryContent.status || afterStatusList.indexOf(deliveryContent.status) < 0) {
              return system.getResultFail(-703, "交付流程错误，请先完成材料收集");
            }
            if (deliveryContent.status == "SUCCESS") {
              return system.getResultFail(-706, "该方案已完成，不可更改");
            }
            deliveryContent['ApplicationStatus'] = 703;
            solutionFlowList.push({
              file: ab.OfficialFileURL || "",
              status: "AUDITING", statusName: this.regSolutionStatus.AUDITING, updated_at: new Date()
            });
            deliveryContent.status = "AUDITING";
            deliveryContent.statusName = this.regSolutionStatus.AUDITING;
            console.log('deliveryContent-----sss---', deliveryContent)
            console.log('deliveryContent-----ss+++', typeof (deliveryContent))
            deliveryContent['deliveryContent'] = deliveryContents
          }
          if (ab.ApplicationStatus == 704) {//刻章环节
            var afterStatusList = [//用户支付后的流程状态
              "COLLECTING", "AUDITING", "ENGRAVING", "SUCCESS"
            ];
            if (!deliveryContent.status || afterStatusList.indexOf(deliveryContent.status) < 0) {
              return system.getResultFail(-704, "交付流程错误，请先工商审核");
            }
            if (deliveryContent.status == "SUCCESS") {
              return system.getResultFail(-707, "该方案已完成，不可更改");
            }
            deliveryContent['ApplicationStatus'] = 704;
            solutionFlowList.push({
              file: ab.OfficialFileURL || "",
              status: "ENGRAVING", statusName: this.regSolutionStatus.ENGRAVING, updated_at: new Date()
            });
            deliveryContent.status = "ENGRAVING";
            deliveryContent.statusName = this.regSolutionStatus.ENGRAVING;
          }
          if (ab.ApplicationStatus == 705) {//已完成
            if (deliveryContent.status != "ENGRAVING") {
              return system.getResultFail(-705, "交付流程错误，请先刻章");
            }
            if (deliveryContent.status == "SUCCESS") {
              return system.getResultFail(-708, "该方案已完成，不可更改");
            }
            deliveryContent['ApplicationStatus'] = 705;
            solutionFlowList.push({
              file: ab.OfficialFileURL || "",
              status: "SUCCESS", statusName: this.regSolutionStatus.SUCCESS, updated_at: new Date()
            });
            deliveryContent.status = "SUCCESS";
            needsolutioninfo.status = "ywc";
            deliveryContent.statusName = this.regSolutionStatus.SUCCESS;
          }
          solutionFlowList = deliveryContent.solutionFlowList || [];
          applicationStatusList = deliveryContent.applicationStatusList || [];
        }
      }
      if (ab.consultType && ab.consultType == "QYJYTC1" || ab.consultType && ab.consultType == "QYJYTC2") {//公司注册套餐1和公司注册套餐2
        if (ab.productType && ab.productType == "GSZZ") {//工商执照
          if (ab.ApplicationStatus == 702) {//材料收集环节
            if (needsolutioninfo.solutionContent.status != "PAID") {
              return system.getResultFail(-702, "交付流程错误，请先完成支付");
            }
          }
          if (ab.ApplicationStatus == 703) {//工商审核环节
            var afterStatusList = [//用户支付后的流程状态
              "COLLECTING", "AUDITING", "ENGRAVING", "SUCCESS"
            ];
            if (!deliveryContent[ab.productType] || (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && afterStatusList.indexOf(deliveryContent[ab.productType].channelStatus) < 0)) {
              return system.getResultFail(-703, "交付流程错误，请先完成材料收集");
            }
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-706, "该方案已完成，不可更改");
            }
          }
          if (ab.ApplicationStatus == 704) {//刻章环节
            var afterStatusList = [//用户支付后的流程状态
              "COLLECTING", "AUDITING", "ENGRAVING", "SUCCESS"
            ];
            if (!deliveryContent[ab.productType].channelStatus || afterStatusList.indexOf(deliveryContent[ab.productType].channelStatus) < 0) {
              return system.getResultFail(-704, "交付流程错误，请先工商审核");
            }
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-707, "该方案已完成，不可更改");
            }
          }
          if (ab.ApplicationStatus == 705) {//已完成
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus != "ENGRAVING") {
              return system.getResultFail(-705, "交付流程错误，请先刻章");
            }
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-708, "该方案已完成，不可更改");
            }
          }
          deliveryContent['GSZZ'] = {
            bizType: ab.consultType,
            bizTypeName: bizTypeName,
            productType: productType,
            productTypeName: "工商执照",
            status: ab.ApplicationStatus,
            statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
            channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
            customerInfo: needsolutioninfo.solutionContent.customerInfo,
            update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
            officialFile: ab.officialFile || "",
            deliveryFlowList: []
          }
        }
        if (ab.productType && ab.productType == "DZFW") {//地址服务
          if (ab.ApplicationStatus == 702) {//材料收集环节
            if (needsolutioninfo.solutionContent.status != "PAID") {
              return system.getResultFail(-702, "交付流程错误，请先完成支付");
            }
          }
          if (ab.ApplicationStatus == 703) {//工商审核环节
            var afterStatusList = [//用户支付后的流程状态
              "COLLECTING", "AUDITING", "ENGRAVING", "SUCCESS"
            ];
            if (!deliveryContent[ab.productType] || (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && afterStatusList.indexOf(deliveryContent[ab.productType].channelStatus) < 0)) {
              return system.getResultFail(-703, "交付流程错误，请先完成材料收集");
            }
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-706, "该方案已完成，不可更改");
            }
          }
          if (ab.ApplicationStatus == 706) {//服务中
            var afterStatusList = [//用户支付后的流程状态
              "COLLECTING", "AUDITING", "SUCCESS"
            ];
            if (!deliveryContent[ab.productType] || (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && afterStatusList.indexOf(deliveryContent[ab.productType].channelStatus) < 0)) {
              return system.getResultFail(-704, "交付流程错误，请先工商审核");
            }
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-707, "该方案已完成，不可更改");
            }
          }
          if (ab.ApplicationStatus == 705) {//已完成
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus != "ACTIVE") {
              return system.getResultFail(-705, "交付流程错误，请先变更状态为服务中");
            }
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-708, "该方案已完成，不可更改");
            }
          }
          deliveryContent['DZFW'] = {
            bizType: ab.consultType,
            bizTypeName: bizTypeName,
            productType: productType,
            productTypeName: "地址服务",
            startTime: startTime || "",
            endTime: endTime || "",
            status: ab.ApplicationStatus,
            statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
            channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
            update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
            officialFile: ab.officialFile || "",
            deliveryFlowList: []
          }
        }
        if (ab.productType && ab.productType == "SWBD") {//税务报道:有已接单,已完成状态
          if (ab.ApplicationStatus == 705) {//已完成
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-707, "该方案已完成，不可更改");
            }
          }
          deliveryContent['SWBD'] = {
            bizType: ab.consultType,
            bizTypeName: bizTypeName,
            productType: productType,
            productTypeName: "税务报道",
            status: ab.ApplicationStatus,
            statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
            channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
            update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
            officialFile: ab.officialFile || "",
            deliveryFlowList: []
          }
        }
        if (ab.productType && ab.productType == "YHKH") {//银行开户、:有已接单,已完成状态
          if (ab.ApplicationStatus == 705) {//已完成
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-707, "该方案已完成，不可更改");
            }
          }
          deliveryContent['YHKH'] = {
            bizType: ab.consultType,
            bizTypeName: bizTypeName,
            productType: productType,
            productTypeName: "银行开户",
            status: ab.ApplicationStatus,
            statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
            channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
            update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
            officialFile: ab.officialFile || "",
            deliveryFlowList: []
          }
        }
        if (ab.productType && ab.productType == "DLJZ") {//代理记账:有已接单,服务中,已完成状态
          if (ab.ApplicationStatus == 706) {//服务中
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "ACTIVE") {
              return system.getResultFail(-707, "该交付单已在服务中，不能重复提交");
            }
          }
          if (ab.ApplicationStatus == 705) {//已完成
            if (deliveryContent[ab.productType] && deliveryContent[ab.productType].channelStatus && deliveryContent[ab.productType].channelStatus == "SUCCESS") {
              return system.getResultFail(-707, "该交付单已在服务中，不能重复提交");
            }
          }
          deliveryContent['DLJZ'] = {
            bizType: ab.consultType,
            bizTypeName: bizTypeName,
            productType: productType,
            productTypeName: "代理记账",
            startTime: startTime || "",
            endTime: endTime || "",
            status: ab.ApplicationStatus,
            statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
            channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
            update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
            officialFile: ab.officialFile || "",
            deliveryFlowList: []
          }
        }
        //如果存在交付信息的话就去进行逻辑判断
        if (deliveryContent && deliveryContent[ab.productType] && deliveryContent[ab.productType].status && deliveryContent[ab.productType].deliveryFlowList) {
          if (this.regStatus[deliveryContent.ApplicationStatus] && this.regStatus[deliveryContent.ApplicationStatus] == ab.ApplicationStatus && ab.ApplicationStatus == 705) {
            return system.getResultFail(-406, "操作失败，该交付已完成，不能更改");
          }
          deliveryFlowList = deliveryContent[ab.productType].solutionFlowList || [];
        }
        deliveryContent[ab.productType].deliveryFlowList.push({
          status: ab.ApplicationStatus,
          statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
          file: ab.officialFile || "",
          update_at: new Date().Format("yyyy-MM-dd hh:mm:ss")
        });
        deliveryContent[ab.productType].status = ab.ApplicationStatus
        deliveryContent[ab.productType].statusName = this.regDeliveryStatusName[ab.ApplicationStatus]
        deliveryContent[ab.productType].channelStatus = this.regDeliveryStatus[ab.ApplicationStatus]
      }
    } else {//如果交付信息不存在
      if (ab.consultType && ab.consultType == "GSREG") {//非套餐
        solutionFlowList = needsolutioninfo.solutionContent.solutionFlowList
        deliveryContent.solutionFlowList = solutionFlowList;
        deliveryContent = needsolutioninfo.solutionContent;
        deliveryContent['ApplicationStatus'] = ab.ApplicationStatus
        applicationStatusList = deliveryContent.applicationStatusList || [];
        if (ab.ApplicationStatus == 702) {//材料收集环节
          if (needsolutioninfo.solutionContent.status != "PAID") {
            return system.getResultFail(-702, "交付流程错误，请先完成支付");
          }
          deliveryContent['ApplicationStatus'] = 702;
          solutionFlowList.push({
            file: ab.OfficialFileURL || "",
            status: "COLLECTING", statusName: this.regSolutionStatus.COLLECTING, updated_at: new Date()
          });
          deliveryContent.status = "COLLECTING";
          deliveryContent.statusName = this.regSolutionStatus.COLLECTING;
        }
        if (ab.ApplicationStatus == 703) {//工商审核环节
          var afterStatusList = [//用户支付后的流程状态
            "COLLECTING", "AUDITING", "ENGRAVING", "SUCCESS"
          ];
          if (!deliveryContent.status || afterStatusList.indexOf(deliveryContent.status) < 0) {
            return system.getResultFail(-703, "交付流程错误，请先完成材料收集");
          }
          if (deliveryContent.status == "SUCCESS") {
            return system.getResultFail(-706, "该方案已完成，不可更改");
          }
          deliveryContent['ApplicationStatus'] = 703;
          solutionFlowList.push({
            file: ab.OfficialFileURL || "",
            status: "AUDITING", statusName: this.regSolutionStatus.AUDITING, updated_at: new Date()
          });
          deliveryContent.status = "AUDITING";
          deliveryContent.statusName = this.regSolutionStatus.AUDITING;
          console.log('deliveryContent-----sss---', deliveryContent)
          console.log('deliveryContent-----ss+++', typeof (deliveryContent))
          deliveryContent['deliveryContent'] = deliveryContents
        }
        if (ab.ApplicationStatus == 704) {//刻章环节
          var afterStatusList = [//用户支付后的流程状态
            "COLLECTING", "AUDITING", "ENGRAVING", "SUCCESS"
          ];
          if (!deliveryContent.status || afterStatusList.indexOf(deliveryContent.status) < 0) {
            return system.getResultFail(-704, "交付流程错误，请先工商审核");
          }
          if (deliveryContent.status == "SUCCESS") {
            return system.getResultFail(-707, "该方案已完成，不可更改");
          }
          deliveryContent['ApplicationStatus'] = 704;
          solutionFlowList.push({
            file: ab.OfficialFileURL || "",
            status: "ENGRAVING", statusName: this.regSolutionStatus.ENGRAVING, updated_at: new Date()
          });
          deliveryContent.status = "ENGRAVING";
          deliveryContent.statusName = this.regSolutionStatus.ENGRAVING;
        }
        if (ab.ApplicationStatus == 705) {//已完成
          if (deliveryContent.status != "ENGRAVING") {
            return system.getResultFail(-705, "交付流程错误，请先刻章");
          }
          if (deliveryContent.status == "SUCCESS") {
            return system.getResultFail(-708, "该方案已完成，不可更改");
          }
          deliveryContent['ApplicationStatus'] = 705;
          solutionFlowList.push({
            file: ab.OfficialFileURL || "",
            status: "SUCCESS", statusName: this.regSolutionStatus.SUCCESS, updated_at: new Date()
          });
          deliveryContent.status = "SUCCESS";
          needsolutioninfo.status = "ywc";
          deliveryContent.statusName = this.regSolutionStatus.SUCCESS;
        }
      }
      if (ab.consultType && ab.consultType == "QYJYTC1" || ab.consultType && ab.consultType == "QYJYTC2") {//公司注册套餐1和公司注册套餐2
        if (ab.consultType == "QYJYTC1") {
          bizTypeName = "企业经营套餐一"
        }
        if (ab.consultType == "QYJYTC2") {
          bizTypeName = "企业经营套餐二"
        }
        switch (productType) {
          case "GSZZ":
            deliveryContent['GSZZ'] = {
              bizType: ab.consultType,
              bizTypeName: bizTypeName,
              productType: productType,
              productTypeName: "工商执照",
              status: ab.ApplicationStatus,
              statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
              channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
              customerInfo: needsolutioninfo.solutionContent.customerInfo,
              update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
              officialFile: ab.officialFile || "",
              deliveryFlowList: []
            }
            break;

          case "YHKH":
            deliveryContent['YHKH'] = {
              bizType: ab.consultType,
              bizTypeName: bizTypeName,
              productType: productType,
              productTypeName: "银行开户",
              status: ab.ApplicationStatus,
              statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
              channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
              update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
              officialFile: ab.officialFile || "",
              deliveryFlowList: []
            }
            break;

          case "SWBD":
            deliveryContent['SWBD'] = {
              bizType: ab.consultType,
              bizTypeName: bizTypeName,
              productType: productType,
              productTypeName: "税务报道",
              status: ab.ApplicationStatus,
              statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
              channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
              update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
              officialFile: ab.officialFile || "",
              deliveryFlowList: []
            }
            break;

          case "DLJZ":
            deliveryContent['DLJZ'] = {
              bizType: ab.consultType,
              bizTypeName: bizTypeName,
              productType: productType,
              productTypeName: "代理记账",
              status: ab.ApplicationStatus,
              statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
              channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
              update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
              officialFile: ab.officialFile || "",
              deliveryFlowList: []
            }
            break;

          case "DZFW":
            deliveryContent['DZFW'] = {
              bizType: ab.consultType,
              bizTypeName: bizTypeName,
              productType: productType,
              productTypeName: "地址服务",
              status: ab.ApplicationStatus,
              statusName: this.regDeliveryStatusName[ab.ApplicationStatus],
              channelStatus: this.regDeliveryStatus[ab.ApplicationStatus],
              update_at: new Date().Format("yyyy-MM-dd hh:mm:ss"),
              officialFile: ab.officialFile || "",
              deliveryFlowList: []
            }
            break;
        }
      }
    }
    deliveryContent = JSON.stringify(deliveryContent);
    deliveryContent=deliveryContent.replace("\\n","")
    let orderdeliveryData = {
      sourceOrderNo: ab.orderNo,
      deliveryContent: deliveryContent,
    }
    if (!orderdeliveryInfo[0]) {
      let sql = "INSERT INTO `c_order_delivery` (`sourceOrderNo`,`deliveryContent`) VALUES (:sourceOrderNo,:deliveryContent)";
      var orderdelivery = await this.orderdeliveryDao.customInsert(sql, orderdeliveryData);
    } else {
      let sql = "UPDATE `c_order_delivery`  SET deliveryContent ='" + deliveryContent + "' where sourceOrderNo='" + ab.orderNo + "'";
      var orderdelivery = await this.orderdeliveryDao.customInsert(sql);
    }
    let orderdeliveryQuery = "SELECT * from `c_order_delivery` where sourceOrderNo='" + ab.orderNo + "'";
    let QueryDatas = {
      sourceOrderNo: ab.orderNo
    }
    orderdelivery = await this.orderdeliveryDao.customQuery(orderdeliveryQuery, QueryDatas)
    console.log('orderdelivery++orderdelivery++++++', orderdelivery)
    //todo 推送云服订单所有交付单状态为完成时订单状态为完成的判断 以下所有注释都是相关代码
    // let gszzDeliveryStatus
    // let yhkhDeliveryStatus
    // let swbdDeliveryStatus

    // let gszzDeliveryStatus2
    // let yhkhDeliveryStatus2
    // let swbdDeliveryStatus2
    // let dljzDeliveryStatus2
    // let dzfwDeliveryStatus2
    // let update_at = new Date().Format("yyyy-MM-dd hh:mm:ss")
    // var deliveryFlag
    // var deliveryFlag2
    if (orderdelivery) {
      orderdelivery = orderdelivery[0]
      orderdelivery["bizId"] = ab.bizId;
      orderdelivery['uapp_id'] = uappId;
      orderdelivery['channelOrderNo'] = channelOrderNo;
      // if (ab.consultType && ab.consultType == "QYJYTC1") {
      //   switch (ab.productType) {
      //     case "GSZZ":
      //       if (deliveryContent["GSZZ"] && deliveryContent["GSZZ"].status == 705) {
      //         gszzDeliveryStatus = 705
      //       }
      //       break;
      //     case "YHKH":
      //       if (deliveryContent["YHKH"] && deliveryContent["YHKH"].status == 705) {
      //         yhkhDeliveryStatus = 705
      //       }
      //       break;
      //     case "SWBD":
      //       if (deliveryContent["SWBD"] && deliveryContent["SWBD"].status == 705) {
      //         swbdDeliveryStatus = 705
      //       }
      //       break;
      //   }
      //   if (gszzDeliveryStatus && yhkhDeliveryStatus && swbdDeliveryStatus && 705 == swbdDeliveryStatus == yhkhDeliveryStatus == gszzDeliveryStatus) {
      //     let sql = "UPDATE `c_order_info`  SET orderStatusName ='已完成',orderStatus= 8,updated_at='" + update_at + "' where orderNo ='" + ab.orderNo + "'";
      //     let updateOrderInfo = await this.orderdeliveryDao.customInsert(sql);
      //     if (updateOrderInfo) {
      //       deliveryFlag = 200
      //       orderdelivery['deliveryFlag'] = deliveryFlag;
      //     }
      //   }
      // }

      // if (ab.consultType && ab.consultType == "QYJYTC2") {
      //   switch (ab.productType) {
      //     case "GSZZ":
      //       if (deliveryContent["GSZZ"] && deliveryContent["GSZZ"].status == 705) {
      //         gszzDeliveryStatus2 = 705
      //       }
      //       break;
      //     case "YHKH":
      //       if (deliveryContent["YHKH"] && deliveryContent["YHKH"].status == 705) {
      //         yhkhDeliveryStatus2 = 705
      //       }
      //       break;
      //     case "SWBD":
      //       if (deliveryContent["SWBD"] && deliveryContent["SWBD"].status == 705) {
      //         swbdDeliveryStatus2 = 705
      //       }
      //       break;
      //     case "DLJZ":
      //       if (deliveryContent["DLJZ"] && deliveryContent["DLJZ"].status == 705) {
      //         dljzDeliveryStatus2 = 705
      //       }
      //       break;
      //     case "DZFW":
      //       if (deliveryContent["DZFW"] && deliveryContent["DZFW"].status == 705) {
      //         dzfwDeliveryStatus2 = 705
      //       }
      //       break;
      //   }
      // if (gszzDeliveryStatus2 && yhkhDeliveryStatus2 && swbdDeliveryStatus2 && dljzDeliveryStatus2 && dzfwDeliveryStatus2 && 705 == swbdDeliveryStatus2 == yhkhDeliveryStatus2 == gszzDeliveryStatus2 == dljzDeliveryStatus2 == dzfwDeliveryStatus2) {
      //   let sql2 = "UPDATE `c_order_info`  SET orderStatusName ='已完成',orderStatus= 8,updated_at='" + update_at + "' where orderNo ='" + ab.orderNo + "'";
      //   let updateOrderInfo2 = await this.orderdeliveryDao.customInsert(sql2);
      //   if (updateOrderInfo2) {
      //     deliveryFlag2 = 200
      //     orderdelivery['deliveryFlag2'] = deliveryFlag2;
      //   }
      // }
      // }
    }
    console.log('orderdelivery++', orderdelivery)
    return system.getResultSuccess(orderdelivery);
  }

}
module.exports = RegCenterOrderService;