const system = require("../system");
const settings = require("../../config/settings");
const moment = require('moment');
const uuid = require('uuid');
const sha256 = require('sha256');

class APIBase {
    constructor() {
        this.execClient = system.getObject("util.execClient");
        this.redisClient = system.getObject("util.redisClient");
        this.userCenterAction = {
            "GetOverviewInfoByUser": "getOverviewInfoByUser",
            "GetOrderList": "getOrderList",
            "GetQualificationCertificateOrderList": "getQcOrderList",
            "GetQcOrderList": "getQcOrderList",
            "GetOrderDetail": "getOrderDetail",
            "GetApplyListByUserAndType": "getApplyListByUserAndType",
            "GetApplyAndSolutionInfo": "getApplyAndSolutionInfo",
            "DescribePriceDetail": "selPrice2TX",
            // "GetOverviewInfoByUser": "getOverviewInfoByUser",
            "SubmitGoodsInfo": "submitGoodsinfo",
            "CreateNeed": "needSubmit",
            "GetNeedList": "needList",
            "GetNeedDetail": "needDetail",
            "GetOrderListByStatus": "getOrderListByStatus",
            "GetQualificationCertificateListByUserAndType": "getQualificationCertificateListByUserAndType",
            "GetQualificationCertificateDetail": "getQualificationCertificateDetail",
            "ModifySolution": "refusalSolution",
            "SendVerificationCode": "sendVerificationCode",
            "CheckBusinessNameList": "checkBusinessNameList",

            "DescribeOverviewInfoByUser": "getOverviewInfoByUser",
            "DescribeOrderList": "getOrderList",
            "DescribeQualificationCertificateOrderList": "getQcOrderList",
            "DescribeOrderDetail": "getOrderDetail",
            "DescribeApplyListByUserAndType": "getApplyListByUserAndType",
            "DescribeApplyAndSolutionInfo": "getApplyAndSolutionInfo",
            "DescribeNeedList": "needList",
            "DescribeNeedDetail": "needDetail",
            "DescribeOrderListByStatus": "getOrderListByStatus",
            "DescribeQualificationCertificateListByUserAndType": "getQualificationCertificateListByUserAndType",
            "DescribeQualificationCertificateDetail": "getQualificationCertificateDetail",
        };
        this.queryAction = [
            "GetOrderList", "getOrderList", "GetOverviewInfoByUser", "getOverviewInfoByUser", "GetOrderList", "getOrderList",
            "GetQualificationCertificateOrderList", "getQcOrderList", "GetQcOrderList", "GetOrderDetail", "getOrderDetail",
            "GetApplyListByUserAndType", "getApplyListByUserAndType", "GetApplyAndSolutionInfo", "getApplyAndSolutionInfo",
            "GetPriceDetail", "getPriceDetail", "GetNeedList", "getNeedList", "GetNeedDetail", "getNeedDetail", "GetOrderListByStatus",
            "getOrderListByStatus", "GetQualificationCertificateListByUserAndType", "getQualificationCertificateListByUserAndType",
            "GetQualificationCertificateDetail", "getQualificationCertificateDetail",
            "DescribeOverviewInfoByUser",
            "DescribeOrderList",
            "DescribeQualificationCertificateOrderList",
            "DescribeQcOrderList",
            "DescribeOrderDetail",
            "DescribeApplyListByUserAndType",
            "DescribeApplyAndSolutionInfo",
            "DescribeNeedList",
            "DescribeNeedDetail",
            "DescribeOrderListByStatus",
            "DescribeQualificationCertificateListByUserAndType",
            "DescribeQualificationCertificateDetail",
        ];

    }
    //-----------------------新的模式------------------开始
    async doexecOverviewMethod(gname, methodname, pobj, query, req) {
        try {
            var shaStr = await sha256(JSON.stringify(pobj));
            //查询缓存
            var cacheRes = await this.redisClient.getCache(shaStr);
            if (cacheRes) {
                return JSON.parse(cacheRes);
            }
            var result = await this[methodname](pobj, query, req);
            if (!result) {
                result = system.getResult(null, "请求的方法返回值为空");
            }
            this.execClient.execLogs("reqPath:" + req.path + "执行doexecOverviewMethod结果", pobj, "center-tmtransaction", result, null);
            //保存缓存
            await this.redisClient.setWithEx(shaStr, JSON.stringify(result), 5);
            return result;
        } catch (error) {
            var stackStr = error.stack ? error.stack : JSON.stringify(error);
            console.log(stackStr, "api调用出现异常，请联系管理员..........")
            var rtnerror = system.getResultFail(-200, "系统出现异常");
            this.execClient.execLogs("reqPath:" + req.path + "执行doexecOverviewMethod异常", pobj, "center-tm-transaction", rtnerror, stackStr);
            if (pobj.Action && action) {
                return {
                    "Response": {
                        "Status": -200,
                        "Error": {
                            "Code": "FailedOperation",//操作失败
                            "Message": req.path + "执行异常"
                        },
                        "RequestId": rtnerror.requestId
                    }
                };
            }
            return rtnerror;
        }
    }


    async doexecMethod(gname, methodname, pobj, query, req) {
        var action = this.userCenterAction[req.body.Action];
        var reqParams = {
            actionType: pobj.actionType,
            actionBody: null
        };
        if (pobj.Action && action) {
            reqParams.actionType = action;
            reqParams.actionBody = pobj;
            var userId = req.body["SubAccountUin"] || req.body["Uin"];
            reqParams.actionBody.UserId = userId || "100000013569";
        } else {
            reqParams.actionBody = pobj.actionBody;
        }
        console.log(JSON.stringify(reqParams), "....req......base......");
        try {
            var shaStr = await sha256(JSON.stringify(reqParams));
            //查询缓存
            if (this.queryAction.indexOf(reqParams.actionType) >= 0) {
                var cacheRes = await this.redisClient.getCache(shaStr);
                if (cacheRes) {
                    return JSON.parse(cacheRes);
                }
            }
            var result = await this[methodname](reqParams, query, req);
            if (!result) {
                result = system.getResult(null, "请求的方法返回值为空");
            }
            result.requestId = pobj.RequestId ? pobj.RequestId : pobj.requestId || uuid.v1();
            var tmpResult = reqParams.actionType && reqParams.actionType.indexOf("List") < 0 ? result : { status: result.status, message: result.message, requestId: result.requestId };
            this.execClient.execLogs("reqPath:" + req.path + "执行doexecMethod结果", reqParams, "center-tm-transaction", tmpResult, null);
            if (pobj.Action && action) {
                result = await this.handleTxResult(result);
                delete req.body["Action"];
            }//处理tx返回数据

            //保存缓存
            await this.redisClient.setWithEx(shaStr, JSON.stringify(result), 5);
            return result;
        } catch (error) {
            var stackStr = error.stack ? error.stack : JSON.stringify(error);
            console.log(stackStr, "api调用出现异常，请联系管理员..........")
            var rtnerror = system.getResultFail(-200, "系统出现异常");
            rtnerror.requestId = pobj.RequestId ? pobj.RequestId : pobj.requestId || uuid.v1();
            this.execClient.execLogs("reqPath:" + req.path + "执行doexecMethod异常", reqParams, "center-tm-transaction", rtnerror, stackStr);
            if (pobj.Action && action) {
                return {
                    "Response": {
                        "Status": -200,
                        "Error": {
                            "Code": "FailedOperation",//操作失败
                            "Message": req.path + "执行异常"
                        },
                        "RequestId": rtnerror.requestId
                    }
                };
            }
            return rtnerror;
        }
    }

    async handleTxResult(result) {
        var newResult = {
            "Response": {
                // "Status": result.status,
                // "RequestId": result.requestId
                //DataSet:""
            }
        };
        var keys = Object.keys(result);
        var self = this;
        for (let k = 0; k < keys.length; k++) {
            const tKey = keys[k];
            if (tKey != "message") {
                const newTKey = await self.InitialToUpperMulti(self, tKey);
                const instanceSet = "InstanceSet";
                const element = result[tKey];
                if (element) {
                    if (tKey != "data") {
                        if (typeof element === 'string' || typeof element === "number" || element instanceof Date || !element) {
                            newResult.Response[newTKey] = element;
                        } else {
                            newResult.Response[newTKey] = JSON.stringify(element);
                        }
                    } else {
                        if (typeof element === 'string' || typeof element === "number" || element instanceof Date || !element) {
                            newResult.Response[instanceSet] = element;
                        } else if (element instanceof Array) {
                            if (element.length == 0) {
                                newResult.Response[instanceSet] = null;
                                continue;
                            }
                            newResult.Response[instanceSet] = [];
                            for (let h = 0; h < element.length; h++) {
                                const arrayElement = element[h];
                                if (typeof arrayElement === 'string' || typeof arrayElement === "number" || arrayElement instanceof Date || !arrayElement) {
                                    newResult.Response[instanceSet].push(arrayElement);
                                } else if (arrayElement instanceof Array) {
                                    newResult.Response[instanceSet].push(JSON.stringify(arrayElement));
                                } else {
                                    var arrayItem = {};
                                    const arrayKeys = Object.keys(arrayElement);
                                    for (let g = 0; g < arrayKeys.length; g++) {
                                        const arrayKey = arrayKeys[g];
                                        const newArrayKey = await self.InitialToUpperMulti(self, arrayKey);
                                        const tmpArrayKeyData = arrayElement[arrayKey];
                                        if (typeof tmpArrayKeyData === 'string' || typeof tmpArrayKeyData === "number" || tmpArrayKeyData instanceof Date || !tmpArrayKeyData) {
                                            arrayItem[newArrayKey] = tmpArrayKeyData;
                                        } else {
                                            arrayItem[newArrayKey] = JSON.stringify(tmpArrayKeyData);
                                        }
                                    }
                                    newResult.Response[instanceSet].push(arrayItem);
                                }
                            }
                        } else {
                            newResult.Response[instanceSet] = {};
                            const dataKeys = Object.keys(element);
                            for (let j = 0; j < dataKeys.length; j++) {
                                const dataKey = dataKeys[j];
                                const newDataKey = await self.InitialToUpperMulti(self, dataKey);
                                const dataElement = element[dataKey];
                                if (typeof dataElement === 'string' || typeof dataElement === "number" || dataElement instanceof Date || !dataElement) {
                                    newResult.Response[instanceSet][newDataKey] = dataElement;
                                } else {
                                    newResult.Response[instanceSet][newDataKey] = JSON.stringify(dataElement);
                                }
                            }
                        }
                    }//data处理                    
                } else {
                    if (tKey != "data") {
                        newResult.Response[newTKey] = typeof element === "number" ? element : null;
                    } else {
                        newResult.Response[instanceSet] = null;
                    }
                }
            }
        }
        if (result.status != 1) {
            newResult.Response["Error"] = {
                "Code": "InternalError",//内部错误
                "Message": result.message
            }
        }
        return newResult;
    }

    async InitialToUpperMulti(self, str) {
        const tmpStrList = str.split('_');
        var tmpStr = "";
        for (let i = 0; i < tmpStrList.length; i++) {
            const elementStr = tmpStrList[i];
            if (elementStr) {
                tmpStr = tmpStr + await self.InitialToUpper(elementStr);
            }
        }
        return tmpStr;
    }
    async InitialToUpper(str) {
        if (!str) {
            return str;
        }
        var resultStr = str.substring(0, 1).toUpperCase() + str.substring(1);
        return resultStr;
    }

    //-----------------------新的模式------------------结束

    async brgDoexecMethod(gname, methodname, pobj, query, req) {
        var param = {
            pobj: pobj,
            query: query
        }
        try {
            var result = await this[methodname](pobj, query, req);
            if (!result) {
                result = system.getResult(null, "请求的方法返回值为空");
            }
            result.requestId = pobj.RequestId ? pobj.RequestId : pobj.requestId || uuid.v1();
            this.execClient.execLogs("brg请求reqPath:" + req.path + "brg请求结果", param, "brg-user-center-brgDoexecMethod", result, null);
            return result;
        } catch (error) {
            var stackStr = error.stack ? error.stack : JSON.stringify(error);
            console.log(stackStr, "api-brg请求调用出现异常，请联系管理员..........");
            var rtnerror = system.getResultTX(-1, "", "brg请求出现异常，error：" + stackStr, null);
            rtnerror.requestId = pobj.RequestId ? pobj.RequestId : pobj.requestId || uuid.v1();
            this.execClient.execLogs("brg请求出现异常reqPath:" + req.path, param, "brg-user-center-brgDoexecMethod", null, stackStr);
            return rtnerror;
        }
    }

    /**
          * 带超时时间的post请求
          * @param {*} req 请求信息
          * @param {*} params 请求数据-json格式
          * @param {*} url 请求地址
          * @param {*} ContentType 请求头类型，默认application/json
          * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
          * @param {*} timeOut 超时时间
          */
    async execPostByTimeOut(req, params, url, ContentType, headData, timeOut = 60) {
        return await this.execClient.execPostTimeOutByBusiness("api.base", params, url, ContentType, headData, timeOut, req);
    }

    /** 
    * 返回20位业务订单号
    * @param {*} prefix 业务前缀
    */
    async getBusUid(prefix) {
        prefix = (prefix || "");
        if (prefix) {
            prefix = prefix.toUpperCase();
        }
        var prefixlength = prefix.length;
        var subLen = 8 - prefixlength;
        var uidStr = "";
        if (subLen > 0) {
            uidStr = await this.getUidInfo(subLen, 60);
        }
        var timStr = moment().format("YYYYMMDDHHmm");
        return prefix + timStr + uidStr;
    }
    /**
     * 返回指定长度的字符串
     * @param {*} len 返回长度
     * @param {*} radix 参与计算的长度，最大为62
     */
    async getUidInfo(len, radix) {
        var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
        var uuid = [], i;
        radix = radix || chars.length;
        if (len) {
            for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
        } else {
            var r;
            uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
            uuid[14] = '4';
            for (i = 0; i < 36; i++) {
                if (!uuid[i]) {
                    r = 0 | Math.random() * 16;
                    uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
                }
            }
        }
        return uuid.join('');
    }
}
module.exports = APIBase;