const Sequelize = require('sequelize');
const settings = require("../../../../config/settings")
const fs = require("fs")
const path = require("path");
var glob = require("glob");
class DbFactory {
  constructor() {
    const dbConfig = settings.database();
    dbConfig.reconnect = {
      max_retries: 10,
      onRetry: function (count) {
        console.log("connection lost, trying to reconnect (" + count + ")");
      }
    };
    this.db = new Sequelize(dbConfig.dbname,
      dbConfig.user,
      dbConfig.password,
      dbConfig.config);
    this.db.Sequelize = Sequelize;
    this.db.Op = Sequelize.Op;
    this.initModels();
    this.initRelations();
  }
  async initModels() {
    var self = this;
    var modelpath = path.normalize(path.join(__dirname, '../..')) + "/models/";
    // console.log(modelpath);
    var models = glob.sync(modelpath + "/**/*.js");
    // console.log(models.length);
    models.forEach(function (m) {
      self.db.import(m);
    });
    console.log("init models....");
  }
  async initRelations() {

  }
  //async getCon(){,用于使用替换table模型内字段数据使用
  getCon() {
    var that = this;
    // await this.db.authenticate().then(()=>{
    //   console.log('Connection has been established successfully.');
    // }).catch(err => {
    //   console.error('Unable to connect to the database:', err);
    //   throw err;
    // });
    //同步模型
    if (settings.env == "dev") {

      //console.log(pa);
      // pconfigObjs.forEach(p=>{
      //   console.log(p.get({plain:true}));
      // });
      // await this.db.models.user.create({nickName:"dev","description":"test user",openId:"testopenid",unionId:"testunionid"})
      // .then(function(user){
      //   var acc=that.db.models.account.build({unionId:"testunionid",nickName:"dev"});
      //   acc.save().then(a=>{
      //       user.setAccount(a);
      //   });
      // });
    }
    return this.db;
  }
}
module.exports = DbFactory;