<a name="menu" href="/doc">返回主目录</a>
1. [工商核名接口](#icname)


## **<a name="icname"> 工商核名接口</a>**
[返回到目录](#menu)
##### URL
[/api/action/icapi/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 Action：CheckBusinessNameList

``` javascript
    {
        "Action": "CheckBusinessNameList",
        "CityName": "北京", // Y 注册城市地区
        "KeyWord": "天达11",// Y 公司字号
        "IndustryType": "文化",// Y 行业类型
        "OrganizationType": "",// N 组织类型
        "SearchType": 1,// N 检索方式：1.ES查询  2.数据接口，查询数据库  3.混合两种查询
        "SitCity": ""// N 组合方式 1: CityName + KeyWord + IndustryType + OrganizationType
                                2: KeyWord + CityName + IndustryType + OrganizationType
                                3: KeyWord + IndustryType + CityName +OrganizationType
    }     
```

#### 返回结果
```javascript
    {
        "Response": {
            "Status": 1,
            "InstanceSet": {
                "BrandList": "[]",
                "CityList": "[]",
                "Code": "200",
                "IdenticalCityList": "[{\"id\":0,\"levels\":\"中\",\"name\":\"北京<em>天达</em>文化传媒有限公司\",\"per\":66,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"}]",
                "Level": "低",
                "Msg": "查询完成",
                "Point": 1100,
                "SensitiveList": "[]",
                "SimilarCityList": "[{\"id\":0,\"levels\":\"中\",\"name\":\"北京星<em>天达</em>文化传播有限公司\",\"per\":63,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"北京金源<em>天达</em>文化发展中心\",\"per\":66,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"北京纬祺<em>天达</em>文化有限公司\",\"per\":66,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"北京圣<em>天达</em>文化交流有限公司\",\"per\":63,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"安艺<em>天达</em>(北京)文化传播有限公司\",\"per\":54,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"北京灵科<em>天达</em>文化用品中心\",\"per\":66,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"北京泽<em>天达</em>文化发展有限公司\",\"per\":63,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"北京佳境<em>天达</em>文化传媒有限公司\",\"per\":60,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"北京鑫业<em>天达</em>文化交流中心\",\"per\":66,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"},{\"id\":0,\"levels\":\"中\",\"name\":\"北京智诚<em>天达</em>文化传媒有限公司\",\"per\":60,\"pinyin\":\"\",\"title\":\"\",\"type\":\"\"}]"
            },
            "RequestId": "ac3eea80-ba17-11ea-a2bb-c30cdcc6eddf"
        }
    }   
```

返回参数说明：
```javascript
    {
        "Response": {
            "Status": 1,
            "InstanceSet": {
                    "brandList": [
                        {
                            "id": 0,   // Int 保留，默认0
                            "levels": "中", // String  核名的相似度，“高”或“中”或“低”：1-29，低；30-69 中；70 以上高
                            "name": "", // String  商标名称
                            "per": 40, // Int 相似度评分，约值
                            "pinyin": "",  // String  如是拼音相同，返回命中词的拼音；其他返回“”
                            "type": ""     // String  保留，默认“”
                        }
                    ],
                    "cityList": [
                         {
                            "id": 0,   // Int 保留，默认0
                            "levels": "中", // String  核名的相似度，“高”或“中”或“低”：1-29，低；30-69 中；70 以上高
                            "name": "", // String  与字号相同的地区城市名词
                            "per": 40, // Int 相似度评分，约值
                            "pinyin": "",  // String  如是拼音相同，返回命中词的拼音；其他返回“”
                            "title": "",   // String  保留，默认“”
                            "type": ""     // String  保留，默认“”
                        }
                    ],
                    "code": "200",
                    "identicalCityList": [
                        {
                        "id": 0,   // Int 保留，默认0
                        "levels": "中", // String  核名的相似度，“高”或“中”或“低”：1-29，低；30-69 中；70 以上高
                        "name": "<em>意欣</em>（北京）医药技术有限公司", // String  企业名称或敏感词
                        "per": 40, // Int 相似度评分，约值
                        "pinyin": "",  // String  如是拼音相同，返回命中词的拼音；其他返回“”
                        "title": "",   // String  保留，默认“”
                        "type": ""     // String  保留，默认“”
                        }
                    ],
                    "level": "低",
                    "msg": "查询完成",
                    "point": 800,
                    "sensitiveList": [
                         {
                        "id":0 ,   // Int 保留，默认0
                        "levels":"" , // String  核名的相似度，“高”或“中”或“低”：1-29，低；30-69 中；70 以上高
                        "name":"" , // String  企业名称或敏感词
                        "per": "", // Int 相似度评分，约值
                        "pinyin": "",  // String  如是拼音相同，返回命中词的拼音；其他返回“”
                        "title": "",   // String  保留，默认“”
                        "type": ""     // String  保留，默认“”
                        }
                    ],
                    "similarCityList": [
                        {
                        "id": 0,   // Int 保留，默认0
                        "levels": "中", // String  核名的相似度，“高”或“中”或“低”：1-29，低；30-69 中；70 以上高
                        "name": "北京<em>意欣</em>千阳文化发展有限责任公司"", // String  企业名称或敏感词
                        "per": 36, // Int 相似度评分，约值
                        "pinyin": "",  // String  如是拼音相同，返回命中词的拼音；其他返回“”
                        "title": "",   // String  保留，默认“”
                        "type": ""     // String  保留，默认“”
                        }
                    ]
            },
            "RequestId": "ac3eea80-ba17-11ea-a2bb-c30cdcc6eddf"
        }
    } 
    
    
Level 准则：
Point：0-49 分通过率为高
Point：50-99 分通过率为中
Point：100 以上通过率为低
```