const system = require("../../../system");
const { PDICT } = require("../../../../config/platform");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class TrademarktransactionService extends ServiceBase {
  constructor() {
    super("tm", ServiceBase.getDaoName(TrademarktransactionService));
  }
  /**
   * 用户获取业务申请实体列表
   * @param {*} pobj 
   */
  async getApplyListByUserAndType(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.ApplyType) {
      return system.getResultFail(-103, "申请主体类型不能为空");
    }
    var limit = ab.PageSize ? Number(ab.PageSize) : 10;
    var offset = ab.PageNumber ? (Number(ab.PageNumber) - 1) * limit : 0
    var countObj = { apply_type: ab.ApplyType, user_id: ab.UserId };
    var whereObj = { apply_type: ab.ApplyType, user_id: ab.UserId };
    if (ab.ApplyName) {
      whereObj["apply_name"] = { [this.db.Op.like]: "%" + ab.ApplyName + "%" };
      countObj["apply_name"] = { [this.db.Op.like]: "%" + ab.ApplyName + "%" };
    }
    if (ab.Domicile) {
      whereObj["domicile"] = { [this.db.Op.like]: "%" + ab.Domicile + "%" };
      countObj["domicile"] = { [this.db.Op.like]: "%" + ab.Domicile + "%" };
    }
    var count = await this.dao.findCount({ where: countObj });
    var list = await this.dao.model.findAll({
      where: whereObj,
      limit: limit,
      offset: offset,
      raw: true,
      attributes: [
        "apply_name",
        "credit_code",
        "apply_type",
        "operator",
        "regist_capital",
        "business_term",
        "establish_time",
        "domicile"
      ],
      order: [["created_at", 'desc']]
    });
    var result = system.getResultSuccess(list);
    result.totalCount = count;
    return result;

  }
  /**
   * 用户根据业务申请实体获取实体信息以及业务信息
   */
  async getApplyAndSolutionInfo(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.CreditCode) {
      return system.getResultFail(-103, "社会统一信用代码不能为空");
    }
    var applyinfo = await this.dao.model.findOne({
      where: { user_id: ab.UserId, credit_code: ab.CreditCode },
      attributes: [
        "user_id",
        "apply_name",
        "credit_code",
        "apply_type",
        "operator",
        "regist_capital",
        "business_term",
        "establish_time",
        "domicile",
        "ent_type",
        "business_scope"
      ],
      raw: true
    });
    if (!applyinfo || !applyinfo.credit_code) {
      return system.getResultFail(-300, "未知申请实体信息");
    }
    var list = await this.orderProductDao.findByCompanyAndUser(applyinfo.credit_code, ab.UserId);
    // var list = await this.dao.getPaidSolutionByApplyInfo(applyinfo);
    var result = { applyInfo: applyinfo, productList: list };
    return system.getResultSuccess(result);
  }
  /**
   * 获取用户概览信息
   */
  async getOverviewInfoByUser(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.ProductTypeOne) {//产品大类
      return system.getResultFail(-103, "产品大类编码不能为空");
    }
    var productTypeOne = "%/" + ab.ProductTypeOne + "/%"
    // { [this.db.Op.like]: productTypeOne }
    var companyCount = await this.dao.findCount({ where: { apply_type: 1, user_id: ab.UserId } });//公司数量
    var selfEmployedPersonCount = await this.dao.findCount({ where: { apply_type: 2, user_id: ab.UserId } });//个体户数量
    var waitConfirmCount = await this.needInfoDao.findCount({ where: { status: 3, user_id: ab.UserId, consult_type: { [this.db.Op.like]: productTypeOne } } });//待确认方案数量
    var waitReceiveFileOrderCount = await this.orderDeliveryDao.findOverviewCount(150, ab.UserId, ab.ProductTypeOne);//待收文件数量
    // if(ab.ProductTypeOne == "qcfw"){//资质证照
    //   var internetContentProviderCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/icp/",ab.UserId);//icp数量
    //   var electronicDataInterchangeCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/edi/",ab.UserId);//edi数量
    //   var resultObj = {
    //     internetContentProviderCount: internetContentProviderCount, waitConfirmCount: waitConfirmCount, electronicDataInterchangeCount: electronicDataInterchangeCount,
    //     waitReceiveFileOrderCount: waitReceiveFileOrderCount
    //   };
    //   return system.getResult(resultObj);
    // }
    var internetContentProviderCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/icp/", ab.UserId);//icp数量
    var electronicDataInterchangeCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/edi/", ab.UserId);//edi数量
    // var resultObj = {
    //   internetContentProviderCount: internetContentProviderCount, waitConfirmCount: waitConfirmCount, electronicDataInterchangeCount: electronicDataInterchangeCount,
    //   waitReceiveFileOrderCount: waitReceiveFileOrderCount
    // };
    var resultObj = {
      companyCount: companyCount, waitConfirmCount: waitConfirmCount, selfEmployedPersonCount: selfEmployedPersonCount,
      waitReceiveFileOrderCount: waitReceiveFileOrderCount, internetContentProviderCount: internetContentProviderCount, electronicDataInterchangeCount: electronicDataInterchangeCount
    };
    return system.getResult(resultObj);
  }

  async tmBatchUpload(pobj, actionbody) {
    if (!pobj || !actionbody) {
      return system.getResultFail(-101, "参数错误");
    }
    if (!actionbody.tm) {
      return system.getResultFail(-102, "请检查商标数据");
    }
    let res = await this.dao.model.bulkCreate(actionbody.tm);
    return system.getResultSuccess(res);
  }

  async tmInfo(pobj, actionBody) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-103, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.channel_code) {
      return system.getResultFail(-104, "渠道码不能为空");
    }
    var limit = ab.PageSize ? Number(ab.PageSize) : 10;
    var offset = ab.PageNumber ? (Number(ab.PageNumber) - 1) * limit : 0
    var countObj = { channel_code: ab.channel_code };
    var whereObj = { channel_code: ab.channel_code };
    if (ab.name) {// 商标名称
      whereObj["name"] = { [this.db.Op.like]: "%" + ab.name + "%" };
      countObj["name"] = { [this.db.Op.like]: "%" + ab.name + "%" };
    }
    if (ab.code) {// 申请号
      whereObj["code"] = { [this.db.Op.like]: "%" + ab.code + "%" };
      countObj["code"] = { [this.db.Op.like]: "%" + ab.code + "%" };
    }
    if (ab.channel_name) {// 申请主体
      whereObj["channel_name"] = { [this.db.Op.like]: "%" + ab.channel_name + "%" };
      countObj["channel_name"] = { [this.db.Op.like]: "%" + ab.channel_name + "%" };
    }
    if (ab.code) {// 申请号
      whereObj["code"] = { [this.db.Op.like]: "%" + ab.code + "%" };
      countObj["code"] = { [this.db.Op.like]: "%" + ab.code + "%" };
    }
    if (ab.start) {// 申请号
      whereObj["created_at"] = { [this.db.Op.between]: [actionBody.stdate, actionBody.endate] };
    }
    var count = await this.dao.findCount({ where: countObj });
    var list = await this.dao.model.findAll({
      where: whereObj,
      limit: limit,
      offset: offset,
      raw: true,
      attributes: [
        "id",
        "pic_url",
        "name",
        "code",
        "ncl_one_code",
        "channel_name",
        "business_quoted_price",
        "tm_start_day",
        "tm_end_day",
        "publish_status_name",
        "created_at"
      ],
      order: [["created_at", 'desc']]
    });
    var result = system.getResultSuccess(list);
    result.totalCount = count;
    return result;
  }

  async tmDetail(pobj, actionBody) {
    if (!actionBody.tmId) {
      return system.getResultFail(-105, "标源id为空");
    }
    var tmDetail = await this.dao.findById(actionBody.tmId);
    return system.getResultSuccess(tmDetail);
  }

  async tmInfoUpdate(pobj, actionBody) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-106, "参数错误");
    }
    var res = this.dao.update(actionBody)
    return system.getResultSuccess(res);
  }

  async tmInfoDelete(pobj, actionBody) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-106, "参数错误");
    }
    var res = this.dao.delete(actionBody)
    return system.getResultSuccess(res);
  }

  async addbaseinfo(objlist) {
    if(!objlist|| objlist.length<1){
      return system.getResultFail(-106,"参数错误");
    }
    if(objlist[0].pic_url){
      await self.addEsData(objlist);
    }else{
      var codeList=[]
      for (let i = 0; i < objlist.length; i++) {
        codeList.push(objlist[i].code);
      }
    }
    var params = {
      "query": {
        "terms": {
          "tm_regist_num": codeList
        }
      },
      "from": 0,
      "size": 500,
      "_source": [
        "pic_url",
        "tm_name",
        "tm_name_en",
        "tm_regist_num",
        "ncl_one_codes",
        "applicant_cn",
        "original_regist_notice_day",
        "tm_end_day",
        "ncl_two_codes",
        "cn_count",
        "en_name_count",
        "regist_notice_day"
      ]
    };
    var esData = await self.returnResult(params, this.tmSearchUrl, "UtilsTmTaskTradeService", "opEsQuery");
    if (esData.status == 0 && esData.data.length > 0) {
      await self.addEsData(auditData, esData.data, self, rc);
    }
  }

  async addEsData(auditData, esTmList, self, rc) {
    var addDbList = [];
    var rtn = null;
    for (let b = 0; b < esTmList.length; b++) {
      const esItem = esTmList[b];
      var auditList = auditData.filter(a => a.code == esItem.tm_regist_num);
      if (!auditList || auditList.length == 0) {
        continue;
      }
      var params = {
        created_at: self.buildDate(auditList[0].created_at),
        tm_regist_num: esItem.tm_regist_num,
        en_name: esItem.tm_name_en,
        en_name_count: esItem.en_name_count,
        en_name_standard: esItem.tm_name_en,
        tm_name: esItem.tm_name,
        tm_name_standard: esItem.tm_name,
        tm_name_count: Number(esItem.cn_count || "0") + Number(esItem.en_name_count || "0"),
        cn_count: esItem.cn_count,
        pic_url: esItem.pic_url,
        pic_url_user: auditList[0].pic_url || "",
        is_transaction: 1,//--------------------db----是否可以交易
        ncl_one_codes: esItem.ncl_one_codes,
        platform_quoted_price: auditList[0].platform_quoted_price,
        tm_heat: 0,
        tm_introduction: auditList[0].tm_introduction,
      };
      try {
        await self.putDbData(esItem, auditData, addDbList, self);
        var esParams = {
          "query": {
            "bool": {
              "must": [
                {
                  "term": {
                    "ncl_one_codes": esItem.ncl_one_codes
                  }
                },
                {
                  "term": {
                    "tm_regist_num": esItem.tm_regist_num
                  }
                }
              ]
            }
          },
          "from": 0,
          "size": 1,
          "_source": [
            "tm_name"
          ]
        };
        var queryEs = await self.returnResult(esParams, this.tmTransactionUrl, "UtilsTmTaskTradeService", "addEsData");
        if (queryEs.status == 0 && queryEs.data && queryEs.data.length == 0) {
          await rc.execPost(params, self.opTmTransactionUrl);
        }
      } catch (e) {
        logCtl.error({
          optitle: "往ES中插入数据或更新商标交易中的商标异常error",
          op: "/igirl-web/app/base/service/impl/utilstmtasktradeSve.js/addEsData.js",
          content: e.stack,
          clientIp: ""
        });
      }
    }
    if (addDbList.length > 0) {
      await this.trademarktransactionDao.model.bulkCreate(addDbList);
    }
  }

  async putDbData(esItem, auditData, addDbList, self) {//更新数据库
    var putIndex = auditData.findIndex(f => f.code === esItem.tm_regist_num);
    if (putIndex < 0) {
      return;
    }

    //商标小项查询
    var params2 = {
      "query": {
        "term": {
          "reg_num": esItem.tm_regist_num
        }
      },
      "from": 0,
      "size": 500,
      "_source": [
        "ncl_last"
      ]
    };
    var nclthird = [];
    var esData2 = await self.returnResult(params2, this.tmNclUrl, "UtilsTmTaskTradeService", "opEsQuery");
    if (esData2.status == 0 && esData2.data.length > 0) {
      for (let l = 0; l < esData2.data.length; l++) {
        if (esData2.data[l].ncl_last.indexOf(":") != -1) {
          var sptirdncl = esData2.data[l].ncl_last.split(":")[1];
          if (nclthird.indexOf(sptirdncl) < 0) {
            nclthird.push(sptirdncl);
          }
        }
        else {
          if (nclthird.indexOf(esData2.data[l].ncl_last) < 0) {
            nclthird.push(esData2.data[l].ncl_last);
          }
        }
      }
    }
    var filterTmListr = auditData.filter(f => f.code === esItem.tm_regist_num );
    var filterTmList = auditData.filter(f => f.code === esItem.tm_regist_num && f.ncl_one_code === esItem.ncl_one_codes);
    if ((!filterTmListr || filterTmListr.length ==0) &&(!filterTmList || filterTmList.length ==0)) {
      var addParams = {
        code: esItem.tm_regist_num,
        ncl_one_code: esItem.ncl_one_codes,
        name: esItem.tm_name,
        excelName: esItem.tm_name,
        tm_applier: esItem.applicant_cn,
        tm_group: JSON.stringify(esItem.ncl_two_codes),
        pic_url: auditData[putIndex].pic_url || esItem.pic_url,
        business_quoted_price: auditData[putIndex].business_quoted_price,
        platform_quoted_price: auditData[putIndex].platform_quoted_price,
        tm_structure_name: auditData[putIndex].tm_structure_name,
        tm_introduction: auditData[putIndex].tm_introduction,
        publish_status: "uppershelf",
        createcompany_id: auditData[0].createcompany_id,
        createuser_id: auditData[0].createuser_id,
        notes: "add_new",
        tm_regist_day: esItem.regist_notice_day,
        tm_ncl_third:  JSON.stringify(nclthird)
      };
      if (esItem.original_regist_notice_day && esItem.original_regist_notice_day != null) {
        addParams.tm_start_day = self.convertDate(esItem.original_regist_notice_day);
      }
      if (esItem.tm_end_day && esItem.tm_end_day != null) {
        addParams.tm_end_day = self.convertDate(esItem.tm_end_day);
      }
      addDbList.push(addParams);
      return;
    }//大类是有值，则新增数据到db
    auditData[putIndex].ncl_one_code = esItem.ncl_one_codes;
    var setField = {
      ncl_one_code: esItem.ncl_one_codes,
      name: esItem.tm_name,
      tm_applier: esItem.applicant_cn,
      tm_group: JSON.stringify(esItem.ncl_two_codes),
      pic_url: auditData[putIndex].pic_url || esItem.pic_url,
      publish_status: "uppershelf",
      tm_regist_day: esItem.regist_notice_day,
      tm_ncl_third:  JSON.stringify(nclthird)
    };
    if (esItem.original_regist_notice_day && esItem.original_regist_notice_day != null) {
      setField.tm_start_day = self.convertDate(esItem.original_regist_notice_day);
    }
    if (esItem.tm_end_day && esItem.tm_end_day != null) {
      setField.tm_end_day = self.convertDate(esItem.tm_end_day);
    }
    var sqlWhere = { where: { id: auditData[putIndex].id } };
    var tmpR = await self.trademarktransactionDao.updateByWhere(setField, sqlWhere);
    return;
  }

}
module.exports = TrademarktransactionService;
