const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
class UserCtl extends CtlBase {
  constructor() {
    super('auth', CtlBase.getServiceName(UserCtl));
  }

  async resetPassword(pobj, qobj, req) {
    await this.service.resetPassword(req.xctx.username, pobj.onepassword);
    return system.getResult({});
  }
  async allowOrNot(pobj, qobj, req) {
    await this.service.updateByWhere({ isEnabled: !pobj.isEnabled }, { company_id: pobj.company_id });
    return system.getResult({});
  }
  async initNewInstance(queryobj, req) {
    const rtn = {};
    rtn.roles = [];
    return system.getResultSuccess(rtn);
  }
  // 获取验证码，发送给指定手机
  // async sendVCode(pobj, qobj, req) {
  //   var mobile = pobj.mobile;
  //   let v = await this.smsS.sendVCode(mobile);
  //   return system.getResult({ vcodestr: v });
  // }
  async exit(pobj, qobj, req) {

  }
  // 应用的自由用户注册,无需验证，需要前端头设置公司KEY
  async pmregisterByFreeUser(p, q, req) {
    // 检查是否有用户名和密码
    if (!pobj.userName || !pobj.password) {
      return system.getResult(null, '请检查用户名和密码是否存在');
    }
    // p.company_id = req.xctx.companyid;//控制基类里已经添加

    if (!p.company_id) {
      return system.getResultFail(-201, '自有用户创建需要提供公司KEY');
    }
    const rtn = await this.service.pmregisterByFreeUser(p, q);
    return rtn;
  }

  async create(p, q, req) {
    // 检查是否有用户名和密码
    if (!p.userName) {
      return system.getResult(null, '请检查用户名和密码是否存在');
    }
    const rtn = await this.service.registerByTantent(p, q);
    return system.getResult(rtn);
  }
  // 登录后的租户创建属于租户的用户
  // 需要在控制器里取出公司ID
  // 和租户绑定同一家公司
  // 按照用户名和密码进行注册
  // 控制器端检查用户名和密码非空
  async registerByTantent(p, q, req) {
    // 检查是否有用户名和密码
    if (!pobj.userName) {
      return system.getResult(null, '请检查用户名和密码是否存在');
    }
    const rtn = await this.service.registerByTantent(p, q);
    return rtn;
  }
  // 租户用户名和密码的租户注册
  async pmregister(pobj, qobj, req) {
    // 平台注册设置平台的应用ID
    pobj.app_id = settings.pmappid;
    // 检查是否有用户名和密码
    if (!pobj.userName || !pobj.password) {
      return system.getResult(null, '请检查用户名和密码是否存在');
    }
    const rtn = await this.service.pmregister(pobj);
    return system.getResult(rtn);
  }
  async pmlogin(pobj, qobj, req) {
    // 平台注册设置平台的应用ID
    const rtn = await this.service.pmlogin(pobj, qobj, req);
    return system.getResult(rtn);
  }
  async getUserInfo(pobj, qobj, req) {
    const uname = req.xctx.username;
    const rtn = await this.service.getUserInfo(uname);
    return system.getResult(rtn);
  }

  // 按照电话创建自由用户
  async pmloginByVCodeForFreeUser(p, q, req) {
    if (!pobj.mobile || !pobj.vcode) {
      return system.getResult(null, '请检查手机号和验证码是否存在');
    }
    p.companykey = req.xctx.companykey;
    if (!p.companykey) {
      return system.getResult(null, '自有用户创建需要提供公司KEY');
    }
    const rtn = await this.service.pmloginByVCodeForFreeUser(p, q);
    return rtn;
  }
  async pmloginByVCode(pobj, qobj, req) {
    const rtn = await this.service.pmloginByVCode(pobj, qobj);
    return system.getResult(rtn);
  }
  async pmSendVCode(pobj, qobj, req) {
    const rtn = await this.service.sendVCode(pobj, qobj);
    return system.getResult(rtn);
  }
}
module.exports = UserCtl;
