const system = require('../../../system');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
// const { json, JSON } = require("sequelize");
const appconfig = system.getSysConfig();
class FitaxschemeCtl extends CtlBase {
  constructor() {
    super('bizchance', CtlBase.getServiceName(FitaxschemeCtl));
    this.rysUrl = settings.rysUrl();
    this.bookUrl = settings.bookUrl();
  }
  /**
     * 新建方案信息
     * @param {*} mobj
    */
  async insertInfo(mobj, qobj, req) {
    const pobj = mobj.d;
    console.log(`fitasschemeCtl:insertInfo:pobj--------------------${JSON.stringify(pobj)}`);
    try {
      if (!pobj.demand_code || !pobj.company_type || !pobj.taxpayer_type || !pobj.service_code || !pobj.buy_duration) {
        return system.getResultError('fitaxschemeCtl/insertInfo 缺少必要参数!');
      }
      const res = await this.service.insertInfo(pobj);
      console.log(`fitasschemeCtl:insertInfo:res--------------------${JSON.stringify(res)}`);
      // 同步方案信息，获取方案编号(走队列，再写一个接收队列方案编号的方法，将方案编号更新到数据库 融易算接口文档2.2)
      // 构造参数
      const pushObj = this.buildObj(pobj);
      system.queueOper(pushObj);
      console.log('fitasschemeCtl:insertInfo:queueOper--------------------新建方案成功');
      return system.getResult('新建方案成功!');
    } catch (error) {
      console.log(`fitaxschemeCtl/insertInfo---------------------------------------------------------------- ${error}`);
      return system.getResultError('fitaxschemeCtl/insertInfo 新建方案出错!');
    }
  }

  /**
     * @param {*} pobj
     * @param {*} qobj
     * @param {*} req
    */
  async updateInfo(pobj, qobj, req) {
    console.log('fitaxscjemeCtl:updateInfo:pobj--------------------', JSON.stringify(pobj));
    const obj = {};
    if (pobj.actionBody.messageBody.IntentionBizId) { // 需求编号
      obj.demand_code = `${pobj.actionBody.messageBody.IntentionBizId}_book`;
    }
    if (pobj.actionBody.resultInfo.Response.BizData.SolutionBizId) { // 方案编号
      obj.solution_bizid = pobj.actionBody.resultInfo.Response.BizData.SolutionBizId;
    }
    try {
      const res = await this.service.updateInfo(obj);
      console.log('fitaxschemeCtl/updateInfo :添加方案编号成功！ ');
      return system.getResult('添加方案编号成功！');
    } catch (error) {
      console.log(`fitaxschemeCtl/updateInfo error: ${error}`);
      return system.getResultError(`添加方案编号失败: ${error}`);
    }
  }

  /**
     * @param {*} pobj
     * @param {*} qobj
     * @param {*} req
    */
  async findInfoByBizid(pobj, qobj, req) { // 方案
    try {
      if (pobj.bizId) {
        const res = await this.service.findInfoByBizid(pobj);
        return system.getResult(res);
      }

      return system.getResultError('缺少方案编号');
    } catch (error) {
      return system.getResultError(error);
    }
  }

  async testCreateProposal(pobj) {
    console.log('testCreateProposal-------------------');
    return {
      requestId: 'd51aa427-738f-4bed-b48d-282da0a74432',
      status: 1,
      success: true,
      errorCode: 0,
      errorMsg: 'ok',
      data: {
        SolutionBizId: 'S20200612152149000001',
      },
    };
  }

  buildObj(pobj) {
    const pushUrl = `${this.rysUrl}/leads/proposal/create`;
    // let pushUrl = this.rysUrl + "/web/bizchance/fitaxschemeCtl/testCreateProposal";
    const notifyUrl = `${this.bookUrl}/web/bizchance/fitaxschemeCtl/updateInfo`;
    let companyType; let sreaCode; let quantity; let taxQualify;
    if (pobj.company_type) { // 公司类型
      if (pobj.company_type == '商业型') {
        companyType = 1;
      } else if (pobj.company_type == '服务型') {
        companyType = 2;
      } else if (pobj.company_type == '特殊行业') {
        companyType = 3;
      } else {
        companyType = 4;
      }
    }
    if (pobj.service_code) { // 区域编码
      sreaCode = parseInt(pobj.service_code);
    }
    if (pobj.buy_duration) { // 数量
      quantity = parseInt(pobj.buy_duration);
    }
    if (pobj.taxpayer_type) { // 纳税人类型
      if (pobj.taxpayer_type == '一般纳税人') {
        taxQualify = 1;
      } else {
        taxQualify = 2;
      }
    }
    const pushObj = {
      pushUrl,
      actionType: 'create',
      notifyUrl,
      messageBody: {
        IntentionBizId: pobj.demand_code.replace(/_book/g, ''),
        BizType: 'bookkeeping',
        Solution: {
          CompanyType: companyType,
          AreaCode: sreaCode,
          Quantity: quantity,
          TaxQualify: taxQualify,
        },
      },
      headData: {
        Authorization: 'Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjE1OTg0MzQ2ODcsImlzcyI6InJFRVN6TU5ZUlM2RnBWNnZlY09vdExPNWdPcUNXSmFQIiwiaWF0IjoxNTk4NDMxMDg3fQ.isQ40HqHHfJ-rTsUQOhRIdu4XCitZU-AfzeqSH4kPbQ',
        XAPPKEY: 'f6b59b74-f943-4735-bb86-e05d6b7fd78e',
        Source: 'GSB',
      },
    };
    return pushObj;
  }
}
module.exports = FitaxschemeCtl;

