const system = require('../../../system');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const appconfig = system.getSysConfig();
class OperationrecordCtl extends CtlBase {
  constructor() {
    super('bizchance', CtlBase.getServiceName(OperationrecordCtl));
    this.bizoptSve = system.getObject('service.bizchance.bizoptSve');
  }

  /**
     * 查询记录信息
     * @param {*} mobj
     * {
            demand_code: "",//必须,需求编号
            operation_type: ""//可选,操作类型
        }
    */
  async findAllInfo(mobj, qobj, req) {
    const pobj = mobj.d;
    try {
      if (!pobj.demand_code) {
        return system.getResultError('operationrecordCtl/findAllInfo 缺少需求编号!');
      }
      const res = await this.service.findAllInfo(pobj);
      return system.getResult(res);
    } catch (error) {
      console.log(`operationrecordCtl/findAllInfo ${error}`);
      return system.getResultError('operationrecordCtl/findAllInfo 查询企业失败!');
    }
  }

  /**
       * 新建记录信息
       * @param {*} mobj
       * {
            demand_code: "",//需求编号
            operation_type: "",//操作类型
            operation_details: {}//操作详细记录
        }
      */
  async insertInfo(mobj, qobj, req) {
    const pobj = mobj.d;
    // 取请求头中的userid和name
    pobj.operator = {
      id: mobj.userid ? mobj.userid : '',
      name: mobj.username ? mobj.username : '',
    };
    try {
      if (!pobj.demand_code) {
        return system.getResultError('fitaxschemeCtl/insertInfo 缺少需求编号!');
      }
      if (pobj.operation_type == 'followUp') {
        if (pobj.operation_details.intention) {
          const obj = { demand_code: pobj.demand_code };
          if (pobj.operation_details.intention == '方案') {
            // 状态修改为 '待确认方案'
            obj.business_status = 'beforeSubmission';
          } else {
            // 状态修改为'跟进中'
            obj.business_status = 'followingUp';
          }
          const bizoptRes = await this.bizoptSve.updateStatusByDemandCode(obj);
        }
      }
      const insertRes = await this.service.insertInfo(pobj);
      return system.getResult('添加记录信息成功!');
    } catch (error) {
      console.log(`operationrecordCtl/insertInfo ${error}`);
      return system.getResultError('operationrecordCtl/insertInfo 添加记录信息失败!');
    }
  }
}
module.exports = OperationrecordCtl;

