const system = require('../../../system');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const appconfig = system.getSysConfig();
class SettleBillCtl extends CtlBase {
  constructor() {
    super('bizchance', CtlBase.getServiceName(SettleBillCtl));
  }
  async advice(p, q, req) {
    const sid = p.advice.settleId;
    const msg = p.advice.memo;
    const { userid } = p;
    const userName = p.username;
    const rtn = await this.service.advice(sid, msg, userid, userName);
    return system.getResult(rtn);
  }
  async  auditPass(p, q, req) {
    const sid = p.pass.settleId;
    const rtn = await this.service.auditPass(sid, p.userid, p.username);
    return system.getResult(rtn);
  }
  async  pay(p, q, req) {
    const sid = p.pay.settleId;
    const rtn = await this.service.pay(sid, p.userid, p.username);
    return system.getResult(rtn);
  }
}
module.exports = SettleBillCtl;

