const system = require('../../../system');
const Dao = require('../../dao.base');
class UserDao extends Dao {
  constructor() {
    super(Dao.getModelName(UserDao));
  }
  async getAuths(userid) {
    const self = this;
    return this.model.findOne({
      where: { id: userid },
      include: [{ model: self.db.models.account, attributes: ['id', 'isSuper', 'referrerOnlyCode'] },
      {
        model: self.db.models.role, as: 'Roles', attributes: ['id', 'code'], include: [
          { model: self.db.models.product, as: 'Products', attributes: ['id', 'code'] },
        ],
      },
      ],
    });
  }
  async getUserByUsername(username, appkey, t) {
    const app = await this.appDao.findOne(appkey);
    const tUser = await this.model.findOne({
      where: { userName: username, app_id: app.id },
      include: [{ model: this.db.models.app, raw: true },
      { model: this.db.models.account, attributes: ['id', 'isSuper', 'referrerOnlyCode'], raw: true },
      {
        model: this.db.models.role, as: 'Roles', attributes: ['id', 'code'], include: [
          { model: this.db.models.product, as: 'Products', attributes: ['id', 'code'], raw: true },
        ],
      },
      ],
    }, { transaction: t });
    // if(tUser!=null){
    //   tUser=tUser.get({plain:true});
    //   tUser.partnerinfo=await this.partnerinfoDao.model.findOne({where:{onlyCode:tUser.onlyCode},raw:true});
    // }
    return tUser;
  }
  async getUserByOpenId(popenid, appkey, t) {
    const app = await this.appDao.findOne(appkey);
    let tUser = await this.model.findOne({
      where: { openId: popenid },
      include: [{ model: this.db.models.app, raw: true },
      { model: this.db.models.account, attributes: ['id', 'isSuper', 'referrerOnlyCode'], raw: true },
      {
        model: this.db.models.role, as: 'Roles', attributes: ['id', 'code'], include: [
          { model: this.db.models.product, as: 'Products', attributes: ['id', 'code'], raw: true },
        ],
      },
      ],
    }, { transaction: t });
    if (tUser != null) {
      tUser = tUser.get({ plain: true });
      tUser.partnerinfo = await this.partnerinfoDao.model.findOne({ where: { onlyCode: tUser.onlyCode }, raw: true });
    }
    return tUser;
  }
  async setAccount(user, account, t) {
    const user = await user.setAccount(account, { transaction: t });
    return user;
  }
  async setApp(user, app, t) {
    // 按照APPId,获取app对象
    const user = await user.setApp(app, { transaction: t });
    return user;
  }
  extraModelFilter() {
    return {
      key: 'include', value: [
        { model: this.db.models.app },
        { model: this.db.models.role, as: 'Roles', attributes: ['id', 'name'] }],
    };
  }
  extraWhere(obj, w, qc, linkAttrs) {
    if (obj.bizpath && obj.bizpath != '') {
      if (obj.bizpath.indexOf('tanents_info') > 0) { // 说明是超级管理员的查询
        w.isAdmin = true;
      } else {
        w.isAdmin = false;
        w.company_id = obj.company_id;
      }
    }
    if (linkAttrs.length > 0) {
      const { search } = obj;
      const lnkKey = linkAttrs[0];
      const strq = `$${lnkKey.replace('~', '.')}$`;
      w[strq] = { [this.db.Op.like]: `%${search[lnkKey]}%` };
    }
    return w;
  }
  async preUpdate(u) {
    if (u.roles && u.roles.length >= 0) {
      const roles = await this.db.models.role.findAll({ where: { id: { [this.db.Op.in]: u.roles } } });
      u.roles = roles;
    }
    return u;
  }
  async update(obj) {
    const obj2 = await this.preUpdate(obj);
    await this.model.update(obj2, { where: { id: obj2.id } });
    const user = await this.model.findOne({ where: { id: obj2.id } });
    if (obj2.roles) {
      user.setRoles(obj2.roles);
    }
    return user;
  }
  async findAndCountAll(qobj, t) {
    const users = await super.findAndCountAll(qobj, t);
    return users;
  }
  async preCreate(u) {
    // var roles=await this.db.models.role.findAll({where:{id:{[this.db.Op.like]:u.roles}}});
    // console.log("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    // console.log(roles);
    // console.log("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    // u.roles=roles
    return u;
  }
  async create(u, t) {
    const self = this;
    const u2 = await this.preCreate(u);
    if (t) {
      console.log('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>');
      console.log(u2);
      return this.model.create(u2, { transaction: t }).then(user => user);
    }
    return this.model.create(u2).then(user => user);
  }

  // 修改用户(user表)公司的唯一码
  async putUserCompanyOnlyCode(userId, companyOnlyCode, result) {
    const customerObj = { companyOnlyCode };
    const putSqlWhere = { where: { id: userId } };
    this.updateByWhere(customerObj, putSqlWhere);
    return result;
  }
}
module.exports = UserDao;
// var u=new UserDao();
// var roledao=system.getObject("db.roleDao");
// (async ()=>{
//   var users=await u.model.findAll({where:{app_id:1}});
//   var role=await roledao.model.findOne({where:{code:"guest"}});
//   console.log(role);
//   for(var i=0;i<users.length;i++){
//     await users[i].setRoles([role]);
//     console.log(i);
//   }
//
// })();
