const system = require('../../../system');
const Dao = require('../../dao.base');
class BizoptDao extends Dao {
  constructor() {
    super(Dao.getModelName(BizoptDao));
  }

  extraWhere(qobj, qw, qc) { // 根据业务员id获取商机信息的组装条件
    console.log(`findAndCountAll漏斗条件筛选:${JSON.stringify(qw)}`);
    qc.raw = true;
    // 检查查询的用户所属公司是否是平台运营公司-1,如果是则不需要添加公司查询条件添加公司查询条件, 不添加路径条件,返回所有数据
    if (qobj.company_id == 1) {
      return qw;
    }
    // 需要添加公司查询条件
    qw.facilitator_id = Number(qobj.company_id);
    /**
             * 数据权限过滤
             * 1. 管理员 (opath 为空)、 销售主管(isPrincipal = true) 、 销售 (isPrincipal = false && opath不为空)
             */
    if (!qobj.opath) { // 管理员 不做处理
    } else if (qobj.isPrincipal) { // 销售主管 查询为空和自己组织结构下的
      qw.$or = [{
        salesman_opcode: {
          $eq: null,
        },
      }, {
        salesman_opcode: { $like: `%${qobj.opath}%` },
      }];
    } else { // 销售 查询自己的
      qw.salesman_opcode = { $like: `%${qobj.opath}%` };
    }
    // 不是来自平台前端查询
    if (qobj.bizpath && qobj.bizpath.indexOf('pmx') < 0) {
      console.log(`bizpath-------------${qobj.bizpath}`);
      qw.business_type = qw.business_type || {
        [this.db.Op.eq]: 'bookkeeping',
      };
      if (qobj.bizpath && qobj.bizpath != '') {
        let status;
        if (qobj.bizpath.indexOf('demandAllocation') > 0) { // 从需求分配列表过来的
          qw.business_status = {
            [this.db.Op.eq]: 'received',
          };
        }
        if (qobj.bizpath.indexOf('demandfollow') > 0 || qobj.bizpath.indexOf('distributionManagement') > 0) { // 从需求跟进列表或分配记录列表过来的
          if (qw.business_status) { // 如果状态漏斗筛选条件存在
            status = qw.business_status;
            qw.business_status = {
              [this.db.Op.eq]: status,
            };
          } else {
            qw.business_status = {
              [this.db.Op.ne]: 'received',
            };
          }
        }
      }
    }

    return qw;
  }

  /* 根据商机编号获取商机详情*/
  async findInfoByDemandCode(qobj) {
    const qcwhere = { demand_code: qobj.demand_code };
    return await this.findOne(qcwhere);
  }

  /* 更新商机状态*/
  async updateStatusByDemandCode(qobj, t) {
    const setobj = { business_status: qobj.business_status };
    if (qobj.close_reason && qobj.close_reason != 'undefined') {
      setobj.close_reason = `${qobj.close_reason}_${qobj.remarks}`;
    } else {
      setobj.close_reason = '';
    }
    const whereobj = { demand_code: qobj.demand_code };
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /* 更新业务员信息*/
  async updateSalesmanInfoByDemandCode(qobj, t) {
    const setobj = {};
    if (qobj.salesmanId && qobj.salesmanId != 'undefined') {
      setobj.salesman_id = qobj.salesmanId;
    };
    if (qobj.salesmanName && qobj.salesmanName != 'undefined') {
      setobj.salesman_name = qobj.salesmanName;
    };
    if (qobj.salesmanOpcode && qobj.salesmanOpcode != 'undefined') {
      setobj.salesman_opcode = qobj.salesmanOpcode;
    };
    if (qobj.salesmanPhone && qobj.salesmanPhone != 'undefined') {
      setobj.salesman_phone = qobj.salesmanPhone;
    };
    if (qobj.facilitatorId && qobj.facilitatorId != 'undefined') {
      setobj.facilitator_id = qobj.facilitatorId;
    };
    if (qobj.facilitatorName && qobj.facilitatorName != 'undefined') {
      setobj.facilitator_name = qobj.facilitatorName;
    };
    const whereobj = { demand_code: qobj.businessMode };
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /* 插入商机信息*/
  async insertInfo(qobj, t) {
    const obj = {
      demand_code: qobj.intentionBizId,
      business_type: qobj.type,
      business_status: qobj.businessStatus,
      business_info: {},
      source_number: qobj.sourceNumber,
      service_address: qobj.area,
      facilitator_id: qobj.facilitatorId,
      facilitator_name: qobj.facilitatorName,
      source_name: qobj.sourceName,
    };
    // business_info START
    if (qobj.topOrgCode && qobj.topOrgCode != 'undefined') {
      obj.business_info.topOrgCode = qobj.topOrgCode;
    }
    if (qobj.requestId && qobj.requestId != 'undefined') {
      obj.business_info.requestId = qobj.requestId;
    }
    if (qobj.mobile && qobj.mobile != 'undefined') {
      obj.business_info.contactsPhone = qobj.mobile;
    }
    if (qobj.area && qobj.area != 'undefined') {
      obj.business_info.serviceName = qobj.area;
    }
    // bussiness_info END
    // other
    if (qobj.closeReason && qobj.closeReason != 'undefined') {
      obj.close_reason = qobj.closeReason;
    }
    if (qobj.salesmanOpcode && qobj.salesmanOpcode != 'undefined') {
      obj.salesman_opcode = qobj.salesmanOpcode;
    }
    if (qobj.salesmanId && qobj.salesmanId != 'undefined') {
      obj.salesman_id = qobj.salesmanId;
    }
    if (qobj.salesmanName && qobj.salesmanName != 'undefined') {
      obj.salesman_name = qobj.salesmanName;
    }
    if (qobj.salesmanPhone && qobj.salesmanPhone != 'undefined') {
      obj.salesman_phone = qobj.salesmanPhone;
    }

    return await this.create(obj, t);
  }

  /**
     * 根据服务实例id查找服务所有信息
     */
  async findByBizId(pobj) {
    const oid = pobj.bizId;
    return await this.findOne({ biz_id: oid });
  }
}
module.exports = BizoptDao;
