const system = require('../../../system');
const Dao = require('../../dao.base');
class DeliverybillDao extends Dao {
  constructor() {
    super(Dao.getModelName(DeliverybillDao));
  }
  extraWhere(qobj, qw, qc) { // 根据业务员id获取交付单信息的组装条件
    qc.raw = true;
    const filters = [];
    // 公司数据过滤
    filters.push({
      facilitator_id: Number(qobj.company_id || -1),
    });
    /**
     * 数据权限过滤
     * 1. 管理员 (opath 为空)、 销售主管(isPrincipal = true) 、 销售 (isPrincipal = false && opath不为空)
     */
    if (!qobj.opath) { // 管理员 不做处理
    } else if (qobj.isPrincipal) { // 销售主管 查询为空和自己组织结构下的
      filters.push({
        $or: [
          {
            delivery_man_opcode: {
              $eq: null,
            },
          }, {
            delivery_man_opcode: { $like: `%${qobj.opath}%` },
          },
        ],
      });
    } else { // 销售 查询自己的
      filters.push({
        delivery_man_opcode: { $like: `%${qobj.opath}%` },
      });
    }

    // 产品类型过滤
    filters.push({
      product_code: system.SERVICECODE.FT,
    });
    // 根据 页面 过滤 交付状态
    switch (qobj.bizpath) {
      case '/deliveryManage/deliveryRecord': // 交付单记录
        // filters.push({
        //   delivery_status: {
        //     $in: [
        //       system.SERVERSESTATUS.CLOSED, system.SERVERSESTATUS.SUCCESS, system.SERVERSESTATUS.INSERVICE,
        //     ]
        //   },
        // });
        break;
      case '/deliveryManage/deliveryDealWith':  // 交付单处理
        // filters.push({
        //   $or: [{
        //     delivery_status: {
        //       $in: [
        //         system.SERVERSESTATUS.RECEIVED, system.SERVERSESTATUS.WAITUSERCONFIRM
        //       ]
        //     }
        //   },
        //   {
        //     delivery_status: system.SERVERSESTATUS.INSERVICE,
        //     $or: [
        //       {
        //         v_setup_status: system.SERVERSESTATUS.NOTSETUP
        //       },
        //       {
        //         v_setup_status: {
        //           $eq: null
        //         }
        //       }
        //     ]
        //   }
        //   ],
        // });
        break;
    }


    /**
     * 筛选 条件
     * company_name、v_coname、v_cophone、delivery_code
     */
    if (qc.where.companyName) {
      filters.push({
        company_name: qc.where.companyName,
      });
      delete qc.where.companyName;
    }
    if (qc.where.contactsName) {
      filters.push({
        v_coname: qc.where.contactsName,
      });
      delete qc.where.contactsName;
    }
    if (qc.where.contactsPhone) {
      filters.push({
        v_cophone: qc.where.contactsPhone,
      });
      delete qc.where.contactsPhone;
    }
    if (qc.where.deliveryNumber) {
      filters.push({
        delivery_code: qc.where.deliveryNumber,
      });
      delete qc.where.deliveryNumber;
    }

    if (qc.where.deliveryStatus) {
      filters.push({
        delivery_status: qc.where.deliveryStatus,
      });
      delete qc.where.deliveryStatus;
    }

    if (qc.where.owner) {
      filters.push({
        delivery_man_name: qc.where.owner,
      });
      delete qc.where.owner;
    }

    if (qc.where.setupStatus) {
      if (qobj && qobj.search && qobj.search.setupStatus && qobj.search.setupStatus === system.SERVERSESTATUS.SETUP) {
        filters.push({
          v_setup_status: qc.where.setupStatus,
        });
      } else {
        filters.push({
          $or: [
            {
              v_setup_status: qc.where.setupStatus,
            },
            {
              v_setup_status: {
                $eq: null,
              },
            },
          ],
        });
      }

      delete qc.where.setupStatus;
    }

    qc.where.$and = filters;
    return qw;
  }

  async insertInfo(qobj, t) {
    return await this.create(qobj, t);
  }

  async updateServer(qobj, t) {
    const setobj = { delivery_info: qobj.delivery_info };
    const whereobj = { biz_id: qobj.biz_id };
    if (qobj.delivery_code && qobj.delivery_code != 'undefined') {
      whereobj.delivery_code = qobj.delivery_code;
    }
    return await this.updateByWhere(setobj, whereobj, t);
  }

  async findOneByDeliveryCodeAndBizId(qobj) {
    const qcwhere = { biz_id: qobj.biz_id };
    if (qobj.delivery_code && qobj.delivery_code != 'undefined') {
      qcwhere.delivery_code = qobj.delivery_code;
    }
    return await this.findOne(qcwhere);
  }
  /**
   * 根据服务实例id查找服务所有信息
   */
  async findByBizId(pobj) {
    const oid = pobj.bizId;
    return await this.findOne({ biz_id: oid });
  }
  /**
   * 根据客户ID（帐套）查找服务所有信息
   */
  async findByClientId(pobj) {
    const oid = pobj.vftClientId;
    return await this.findOne({ v_ftClientId: oid });
  }
}
module.exports = DeliverybillDao;
