const system = require('../../../system');
const Dao = require('../../dao.base');
class FitaxcompanyDao extends Dao {
  constructor() {
    super(Dao.getModelName(FitaxcompanyDao));
  }

  /**
   *查询
   *@param {*}  qobj
  */
  async findInfo(qobj) {
    const obj = {
      demand_code: qobj.demand_code, // 需求编码
    };
    return await this.findOne(obj);
  }

  /**
   *修改
   *@param {*}  qobj
   * @param {*} t
  */
  async updateInfo(qobj, t) {
    const obj = this.buildObj(qobj);
    const whereObj = { demand_code: obj.demand_code };
    return await this.updateByWhere(obj, whereObj, t);
  }

  /**
   * 插入信息
   * @param {*} qobj
   * @param {*} t
   */
  async insertInfo(qobj, t) {
    const obj = this.buildObj(qobj);
    return await this.create(obj, t);
  }

  buildObj(qobj) {
    const obj = {
      demand_code: qobj.demand_code, // 需求编码
    };
    if (qobj.company_name) { // 企业名称
      obj.company_name = qobj.company_name;
    }
    if (qobj.legal_person) { // 法人姓名
      obj.legal_person = qobj.legal_person;
    }
    if (qobj.tax_number) { // 税号
      obj.tax_number = qobj.tax_number;
    }
    if (qobj.taxpayer_type) { // 纳税人类型
      obj.taxpayer_type = qobj.taxpayer_type;
    }
    if (qobj.engaged_industry) { // 所属行业
      obj.engaged_industry = qobj.engaged_industry;
    }
    if (qobj.region) { // 地区
      obj.region = qobj.region;
    }
    if (qobj.address) { // 企业地址
      obj.address = qobj.address;
    }
    return obj;
  }
}
module.exports = FitaxcompanyDao;
