const system = require('../../../system');
const Dao = require('../../dao.base');
class FitaxpushqueueDao extends Dao {
  constructor() {
    super(Dao.getModelName(FitaxpushqueueDao));
  }

  /**
  *查询
  *@param {*}  qobj
 */
  async findInfo(qobj) {
    const obj = {
      delivery_code: qobj.delivery_code, // 交付单id
    };
    return await this.findOne(obj);
  }

  /**
   * 插入信息
   * @param {*} qobj
   * @param {*} t
   */
  async insertInfo(qobj, t) {
    try {
      const obj = this.buildObj(qobj);
      console.log(`obj------------------------------${obj}`);
      return await this.create(obj, t);
    } catch (error) {
      console.log(`error-------------------------${error}`);
      return error;
    }
  }

  /**
   *更新方案信息(主要是添加方案编号)
   *@param {*}  qobj
   * @param {*} t
  */
  async updateInfo(qobj, t) {
    const obj = {};
    if (qobj.req_data) {
      obj.req_data = qobj.req_data;
    }
    if (qobj.res_data) {
      obj.res_data = qobj.res_data;
    }
    if (qobj.push_status) {
      obj.push_status = qobj.push_status;
    }
    if (qobj.rys_check) {
      obj.rys_check = qobj.rys_check;
    }
    if (qobj.data_type) {
      obj.data_type = qobj.data_type;
    }
    if (qobj.check_date) {
      obj.check_date = qobj.check_date;
    }
    const whereObj = { delivery_code: qobj.delivery_code, current_period: qobj.current_period };
    return await this.updateByWhere(obj, whereObj, t);
  }

  buildObj(qobj) {
    const obj = {
      delivery_code: qobj.delivery_code,
    };
    if (qobj.current_period) {
      obj.current_period = qobj.current_period;
    }
    if (qobj.data_type) {
      obj.data_type = qobj.data_type;
    }
    if (qobj.req_data) {
      obj.req_data = qobj.req_data;
    }
    if (qobj.res_data) {
      obj.res_data = qobj.res_data;
    }
    if (qobj.push_status) {
      obj.push_status = qobj.push_status;
    }
    if (qobj.rys_check) {
      obj.rys_check = qobj.rys_check;
    }
    if (qobj.check_date) {
      obj.check_date = qobj.check_date;
    }
    return obj;
  }
}
module.exports = FitaxpushqueueDao;
