const system = require('../../../system');
const Dao = require('../../dao.base');
class FitaxschemeDao extends Dao {
  constructor() {
    super(Dao.getModelName(FitaxschemeDao));
  }

  /**
  *查询
  *@param {*}  qobj
 */
  async findInfo(qobj) {
    const obj = {
      demand_code: qobj.demand_code, // 需求编码
    };
    return await this.findOne(obj);
  }

  /**
   * 插入方案信息
   * @param {*} qobj
   * @param {*} t
   */
  async insertInfo(qobj, t) {
    try {
      const obj = this.buildObj(qobj);
      console.log(`obj------------------------------${obj}`);
      return await this.create(obj, t);
    } catch (error) {
      console.log(`error-------------------------${error}`);
      return error;
    }
  }

  /**
   *更新方案信息(主要是添加方案编号)
   *@param {*}  qobj
   * @param {*} t
  */
  async updateInfo(qobj, t) {
    const obj = {};
    if (qobj.solution_bizid) { // 方案编号
      obj.solution_bizid = qobj.solution_bizid;
    }
    const whereObj = { demand_code: qobj.demand_code };
    return await this.updateByWhere(obj, whereObj, t);
  }

  buildObj(qobj) {
    const obj = {
      demand_code: qobj.demand_code, // 需求编码
    };
    if (qobj.solution_bizid) { // 方案编号
      obj.solution_bizid = qobj.solution_bizid;
    }
    if (qobj.service_type) { // 服务类型
      obj.service_type = qobj.service_type;
    }
    if (qobj.company_type) { // 公司类型
      obj.company_type = qobj.company_type;
    }
    if (qobj.taxpayer_type) { // 纳税人类型
      obj.taxpayer_type = qobj.taxpayer_type;
    }
    if (qobj.service_name) { // 服务地区
      obj.service_name = qobj.service_name;
    }
    if (qobj.service_code) { // 服务地区编码
      obj.service_code = qobj.service_code;
    }
    if (qobj.buy_duration) { // 购买时长
      obj.buy_duration = qobj.buy_duration;
    }
    if (qobj.number) { // 数量
      obj.number = qobj.number;
    }
    if (qobj.total_cost) { // 总计费用
      obj.total_cost = qobj.total_cost;
    }
    if (qobj.remarks) { // 备注
      obj.remarks = qobj.remarks;
    }
    return obj;
  }

  async findInfoByBizid(qobj) {
    const obj = {
      solution_bizid: qobj.bizId,
    };
    return await this.findOne(obj);
  }
}
module.exports = FitaxschemeDao;
