const system = require('../../../system');
const Dao = require('../../dao.base');
class SchemeDao extends Dao {
  constructor() {
    super(Dao.getModelName(SchemeDao));
  }

  /* 根据商机编号获取方案信息详情*/
  async findInfoByDemandCode(qobj) {
    const qcwhere = { demand_code: qobj.businessMode };
    return await this.findOne(qcwhere);
  }

  /* 根据方案编号更新方案状态及原因*/
  async updateStatusByDemandCode(qobj, t) {
    const setobj = { scheme_status: qobj.currentStatus };
    if (qobj.statusReason && qobj.statusReason != 'undefined') {
      setobj.reject_reason = qobj.statusReason;
    } else {
      setobj.reject_reason = '';
    }
    const whereobj = { demand_code: qobj.businessMode };
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /* 根据商机编号更新方案详情*/
  async updateInfoByDemandCode(qobj, t) {
    const whereobj = { demand_code: qobj.businessMode };
    const setobj = { scheme_info: qobj.baseInfo, scheme_status: qobj.currentStatus };
    if (qobj.schemeNumber && qobj.schemeNumber != 'undefined') {
      setobj.scheme_number = qobj.schemeNumber;
    }
    if (qobj.statusReason && qobj.statusReason != 'undefined') {
      setobj.reject_reason = qobj.statusReason;
    } else {
      setobj.reject_reason = '';
    }
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /* 根据方案编号更新方案编号*/
  async updateSchemeNumberByDemandCode(qobj, t) {
    const setobj = { scheme_number: qobj.schemeNumber };
    const whereobj = { demand_code: qobj.businessMode };
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /* 插入方案信息*/
  async insertInfo(qobj, t) {
    const obj = {
      demand_code: qobj.businessMode,
      scheme_info: qobj.baseInfo,
    };
    if (qobj.currentStatus && qobj.currentStatus != 'undefined') {
      obj.scheme_status = qobj.currentStatus;
    }
    if (qobj.schemeNumber && qobj.schemeNumber != 'undefined') {
      obj.scheme_number = qobj.schemeNumber;
    }
    if (qobj.statusReason && qobj.statusReason != 'undefined') {
      obj.reject_reason = qobj.statusReason;
    }
    if (qobj.memoInfo && qobj.memoInfo != 'undefined') {
      obj.remark_info = qobj.memoInfo;
    }
    if (qobj.businessId && qobj.businessId != 'undefined') {
      obj.bizopt_id = qobj.businessId;
    }
    if (qobj.servicerCode && qobj.servicerCode != 'undefined') {
      obj.facilitator_id = qobj.servicerCode;
    }
    if (qobj.servicerName && qobj.servicerName != 'undefined') {
      obj.facilitator_name = qobj.servicerName;
    }
    if (qobj.clerkOpcode && qobj.clerkOpcode != 'undefined') {
      obj.salesman_opcode = qobj.clerkOpcode;
    }
    if (qobj.clerkId && qobj.clerkId != 'undefined') {
      obj.salesman_id = qobj.clerkId;
    }
    if (qobj.clerkName && qobj.clerkName != 'undefined') {
      obj.salesman_name = qobj.clerkName;
    }
    if (qobj.clerkPhone && qobj.clerkPhone != 'undefined') {
      obj.salesman_phone = qobj.clerkPhone;
    }
    return await this.create(obj, t);
  }
}
module.exports = SchemeDao;
