const system = require('../../../system');
const settings = require('../../../../config/settings');
const appconfig = system.getSysConfig();
/**
 * 财税-企业信息表
 */
module.exports = (db, DataTypes) => db.define('fitaxcompany', {
  demand_code: { // 需求编码
    allowNull: true,
    type: DataTypes.STRING,
  },
  company_name: { // 企业名称
    allowNull: true,
    type: DataTypes.STRING,
  },
  legal_person: { // 法人姓名
    allowNull: true,
    type: DataTypes.STRING,
  },
  tax_number: { // 税号
    allowNull: true,
    type: DataTypes.STRING,
  },
  taxpayer_type: { // 纳税人类型
    allowNull: true,
    type: DataTypes.STRING,
  },
  engaged_industry: { // 所属行业
    allowNull: true,
    type: DataTypes.STRING,
  },
  region: { // 地区
    allowNull: true,
    type: DataTypes.STRING,
  },
  address: { // 企业地址
    allowNull: true,
    type: DataTypes.STRING,
  },
}, {
  paranoid: false, // 假的删除
  underscored: true,
  version: false,
  freezeTableName: true,
  // freezeTableName: true,
  // define the table's name
  tableName: 'fi_tax_company',
  validate: {

  },
  indexes: [
    // Create a unique index on email
    //  {
    //    unique: true,
    //    fields: ['email']
    //  },
    //
    //  // Creates a gin index on data with the jsonb_path_ops operator
    //  {
    //    fields: ['data'],
    //    using: 'gin',
    //    operator: 'jsonb_path_ops'
    //  },
    //
    //  // By default index name will be [table]_[fields]
    //  // Creates a multi column partial index
    //  {
    //    name: 'public_by_author',
    //    fields: ['author', 'status'],
    //    where: {
    //      status: 'public'
    //    }
    //  },
    //
    //  // A BTREE index with a ordered field
    //  {
    //    name: 'title_index',
    //    method: 'BTREE',
    //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
    //  }
  ],
});

