const system = require('../../../system');
const settings = require('../../../../config/settings');
const appconfig = system.getSysConfig();
/**
 * 财税-推送信息表
 */
module.exports = (db, DataTypes) => db.define('fitaxpushqueue', {
  delivery_code: { // 交付单id
    allowNull: true,
    type: DataTypes.STRING,
  },
  current_period: { // 当前帐期
    allowNull: true,
    type: DataTypes.STRING,
  },
  data_type: { // 数据类型
    allowNull: true,
    type: DataTypes.STRING,
  },
  req_data: { // 推送请求数据
    allowNull: true,
    type: DataTypes.JSON,
  },
  res_data: { // 推送返回数据
    allowNull: true,
    type: DataTypes.JSON,
  },
  push_status: { // 推送状态
    allowNull: true,
    type: DataTypes.STRING,
  },
  rys_check: { // 融易算是否确认
    allowNull: true,
    type: DataTypes.STRING,
  },
  check_date: { // 融易算确认时间
    allowNull: true,
    type: DataTypes.DATE,
  },
}, {
  paranoid: false, // 假的删除
  underscored: true,
  version: true,
  freezeTableName: true,
  // freezeTableName: true,
  // define the table's name
  tableName: 'fi_tax_push_queue',
  validate: {

  },
  indexes: [
    // Create a unique index on email
    //  {
    //    unique: true,
    //    fields: ['email']
    //  },
    //
    //  // Creates a gin index on data with the jsonb_path_ops operator
    //  {
    //    fields: ['data'],
    //    using: 'gin',
    //    operator: 'jsonb_path_ops'
    //  },
    //
    //  // By default index name will be [table]_[fields]
    //  // Creates a multi column partial index
    //  {
    //    name: 'public_by_author',
    //    fields: ['author', 'status'],
    //    where: {
    //      status: 'public'
    //    }
    //  },
    //
    //  // A BTREE index with a ordered field
    //  {
    //    name: 'title_index',
    //    method: 'BTREE',
    //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
    //  }
  ],
});

