const system = require('../../../system');
const ServiceBase = require('../../sve.base');
const settings = require('../../../../config/settings');
const { json } = require('sequelize');
const appconfig = system.getSysConfig();
class FitaxschemeService extends ServiceBase {
  constructor() {
    super('bizchance', ServiceBase.getDaoName(FitaxschemeService));
  }

  async insertInfo(qobj) { // 插入方案信息
    const self = this;
    return await self.db.transaction(async t => await self.dao.insertInfo(qobj, t));
  }

  async findInfo(qobj) { // 查询方案信息
    const self = this;
    return await self.dao.findInfo(qobj);
  }

  async findInfoByBizid(qobj) {
    return await this.dao.findInfoByBizid(qobj);
  }

  async updateInfo(qobj) { // 更新方案信息
    const self = this;
    return await self.db.transaction(async t => await self.dao.updateInfo(qobj, t));
  }
}
module.exports = FitaxschemeService;

// var task = new FitaxschemeService();
// test()
// async function test() {
//     var obj = {
//         "demand_code": "20200728103902194844_book",
//     }
//     let res = await task.findInfo(obj);
//     if (res) {
//         console.log("返回结果：" + JSON.stringify(res));
//     }
// }
