const system = require('../../../system');
const ServiceBase = require('../../sve.base');
const settings = require('../../../../config/settings');
const appconfig = system.getSysConfig();
class SchemeService extends ServiceBase {
  constructor() {
    super('bizchance', ServiceBase.getDaoName(SchemeService));
  }

  async findById(qobj) { // 根据id获取方案信息
    const oid = qobj.id;
    return await this.dao.findById(oid);
  }

  async findInfoByDemandCode(qobj) { // 根据方案编号获取方案详情
    return await this.dao.findInfoByDemandCode(qobj);
  }

  async updateStatusByDemandCode(qobj) { // 根据商机编号号更新方案状态及原因
    const self = this;
    return self.db.transaction(async t => await self.dao.updateStatusByDemandCode(qobj, t));
  }

  async updateInfoByDemandCode(qobj) { // 根据商机编号更新方案详情
    const self = this;
    return self.db.transaction(async t => await self.dao.updateInfoByDemandCode(qobj, t));
  }

  async updateSchemeNumberByDemandCode(qobj) { // 根据商机编号更新方案编号
    const self = this;
    return self.db.transaction(async t => await self.dao.updateSchemeNumberByDemandCode(qobj, t));
  }

  async insertInfo(qobj) { // 插入方案信息
    const self = this;
    return await self.db.transaction(async t => await self.dao.insertInfo(qobj, t));
  }
}
module.exports = SchemeService;
