const system = require('../../../system');
const ServiceBase = require('../../sve.base');
const settings = require('../../../../config/settings');
const uuidv4 = require('uuid/v4');
class CachSearchesSve {
  constructor() {
    this.cacheManager = system.getObject('db.common.cacheManager');
    this.appDao = system.getObject('db.common.appDao');
    this.authUtils = system.getObject('util.businessManager.authUtils');
  }
  getUUID() {
    const uuid = uuidv4();
    const u = uuid.replace(/-/g, '');
    return u;
  }
  async buildCacheRtn(pageValues) {
    const ps = pageValues.map((k) => {
      const tmpList = k.split('|');
      if (tmpList.length == 2) {
        return { name: tmpList[0], val: tmpList[1], key: k };
      }
    });
    return ps;
  }
  async findAndCountAllCache(obj) {
    const { pageNo } = obj.pageInfo;
    const { pageSize } = obj.pageInfo;
    const limit = pageSize;
    const offset = (pageNo - 1) * pageSize;
    const searchName = obj.search && obj.search.name ? obj.search.name : '';

    const cacheCacheKeyPrefix = `sadd_base_appkeys:${settings.appKey}_cachekey`;
    if (obj.appid == settings.platformid) {
      let cacheList = await this.cacheManager.MagCache.getCacheSmembersByKey(cacheCacheKeyPrefix);
      if (searchName) {
        cacheList = cacheList.filter(f => f.indexOf(searchName) >= 0);
      }
      const pageValues = cacheList.slice(offset, offset + limit);
      const kobjs = await this.buildCacheRtn(pageValues);
      const tmpList = { results: { rows: kobjs, count: cacheList.length } };
      return system.getResult(tmpList);
    }
    const body = {
      pageInfo: obj.pageInfo,
      search: obj.search,
    };
    const tmpList = await this.opOtherAppCache('findAndCountAll', body, obj.opCacheUrl);
    return tmpList;
  }
  async delCache(obj) {
    if (obj.appid == settings.platformid) {
      const keyList = obj.key.split('|');
      if (keyList.length == 2) {
        const cacheCacheKeyPrefix = `sadd_base_appkeys:${settings.appKey}_cachekey`;
        await this.cacheManager.MagCache.delCacheBySrem(cacheCacheKeyPrefix, obj.key);
        await this.cacheManager.MagCache.del(keyList[0]);
        return { status: 0 };
      }
    } else {
      const body = {
        del_cachekey: obj.key,
      };
      return await this.opOtherAppCache('delCache', body, obj.opCacheUrl);
    }
  }
  async clearAllCache(obj) {
    if (obj.appid == settings.platformid) {
      await this.cacheManager.MagCache.clearAll();
      return { status: 0 };
    }
    return await this.opOtherAppCache('clearAllCache', {}, obj.opCacheUrl);
  }
  // app调用次数
  async findAndCountAlldetail(obj) {
    const apicallAccu = await this.cacheManager.ApiAccuCache.getApiCallAccu(obj);
    const result = { rows: [], count: 0 };
    const keys = await this.cacheManager.MagCache.keys(`api_call_${appkey}*`);
    let detail = null;
    for (let j = 0; j < keys.length; j++) {
      const d = keys[j];
      const pathdetail = d.substr(d.lastIndexOf('_') + 1, d.length);
      const apicalldetailAccu = await this.cacheManager.ApiCallCountCache.getApiCallCount(appkey, pathdetail);
      detail = { detailPath: d, detailCount: apicalldetailAccu.callcount };
    }
    result.rows = detail;
  }
  // 操作别的应用的缓存
  async opOtherAppCache(actionType, body = null, opCacheUrl) {
    const appData = await this.authUtils.getTokenInfo(settings.appKey, settings.secret);
    if (appData.status != 0) {
      return appData;
    }
    // 按照访问token
    const restS = await system.getObject('util.restClient');
    const restResult = await restS.execPostWithAK(
      {
        action_type: actionType,
        body,
      },
      opCacheUrl, appData.data.accessKey,
    );

    if (restResult && restResult.status == 0) {
      return restResult;
    }
    return system.getResultFail();
  }
}
module.exports = CachSearchesSve;
