﻿const url = require('url');
const System = require('../../base/system');
const deliverService = System.getObject('service.bizchance.deliverybillSve');
module.exports = function (app) {
  app.get('/api/:gname/:qname/:method', (req, res) => {
    // var classPath = req.params["qname"];
    const methodName = req.params.method;
    const { gname } = req.params;
    classPath = `${gname}.${classPath}`;
    const tClientIp = System.getClientIp(req);
    req.clientIp = tClientIp;
    req.uagent = req.headers['user-agent'];
    // req.classname=classPath;

    const params = [];
    params.push(gname);
    params.push(methodName);
    params.push(req.body);
    params.push(req.query);
    params.push(req);
    let p = null;
    const invokeObj = System.getObject(`api.${classPath}`);
    if (invokeObj.doexec) {
      p = invokeObj.doexec.apply(invokeObj, params);
    }
    p.then((r) => {
      res.end(JSON.stringify(r));
    });
  });
  app.post('/api/:gname/:qname/:method', (req, res) => {
    let classPath = req.params.qname;
    const methodName = req.params.method;
    const { gname } = req.params;
    const params = [];
    classPath = `${gname}.${classPath}`;
    console.log('====================');
    console.log(classPath);
    const tClientIp = System.getClientIp(req);
    req.clientIp = tClientIp;
    req.uagent = req.headers['user-agent'];
    // req.classname=classPath;

    params.push(gname);
    params.push(methodName);
    params.push(req.body);
    params.push(req.query);
    params.push(req);
    let p = null;
    const invokeObj = System.getObject(`api.${classPath}`);
    if (invokeObj.doexec) {
      p = invokeObj.doexec.apply(invokeObj, params);
    }
    p.then((r) => {
      res.end(JSON.stringify(r));
    });
  });

  app.post('/acceptFtCallback', async (req, res, next) => {
    console.log('-------------- 财税  acceptFtCallback ------------');
    try {
      console.log(JSON.stringify(req.body));
      await deliverService.fromFtToRys(req.body);
      res.json({
        code: 1,
        msg: 'SUCCESS',
        data: 'SUCCESS',
        success: true,
      });
    } catch (err) {
      console.log(err);
      res.json({
        status: 0,
        msg: err.message,
        data: null,
        success: false,
      });
    }
  });
};
