const path = require('path');
const ENVINPUT = {
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  DB_NAME: process.env.DELIVERY_DB_NAME,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  REDIS_DB: process.env.PAAS_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : 'localhost',
  ENCRYPT_KEY: process.env.ENCRYPT_KEY ? process.env.ENCRYPT_KEY : '202007211106',
  ENCRYPT_SECRET: process.env.ENCRYPT_SECRET ? process.env.ENCRYPT_SECRET : 'scbb846246874887b5c7e01cd0816c66',
};
const settings = {
  env: ENVINPUT.APP_ENV,
  encrypt_key: ENVINPUT.ENCRYPT_KEY,
  encrypt_secret: ENVINPUT.ENCRYPT_SECRET,
  salt: '%iatpD1gcxz7iF#B',
  defaultpwd: 'gsb2020',
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 8889,
  logindex: 'center_manage',
  appname: 'book-deliver',
  kongurl() {
    if (this.env == 'localhost') {
      const localsettings = require('./localsettings');
      return localsettings.kongurl;
    }
    return ENVINPUT.KONG_ADMIAN;
  },
  receiveUrl() {
    if (this.env == 'localhost') {
      return 'http://192.168.1.140:4011/api/receive/entService/springBoard';
    }
    return 'http://brg-user-center-service/api/receive/entService/springBoard';
  },
  queueUrl() {
    if (this.env == 'localhost') {
      return 'http://192.168.1.4:4018/api/queueAction/producer/springBoard';
    }
    return 'http://sytxpublic-msgq-service/api/queueAction/producer/springBoard';
  },
  wdyUrl() {
    if (this.env == 'localhost') {
      return 'http://192.168.1.113:4011/api/action/order/springBoard';
    }
    return 'http://brg-user-center-service/api/action/order/springBoard';
  },
  logUrl() {
    if (this.env == 'localhost') {
      return 'http://43.247.184.94:7200/api/queueAction/producer/springBoard';
    }
    return 'http://logs-sytxpublic-msgq-service/api/queueAction/producer/springBoard';
  },
  rysUrl() { // 先和bookurl一样，后续再调整
    if (this.env == 'localhost') {
      return 'http://192.168.1.6:8889';
    }
    return 'http://abk.tencentyun.com/promise';
  },
  bookUrl() {
    if (this.env == 'localhost') {
      return 'http://192.168.1.6:8889';
    }
    return 'http://bookdeliver-service';
  },
  ftConfig() {
    if (this.env == 'localhost') {
      return {
        channelCode: 'e0kj8ehs',
        secret: '92a15b9b4c5a9ea708bb5583408e1441',
        url: 'https://nt-api.gongsibao.com/nga-api',
      };
    }
    return {
      channelCode: 'nn1oxbsh',
      secret: 'b62a2a896d09a30987d93f9a967e3a6a',
      url: 'http://caishuibao.tencentyun.com/nga-api',
    };
  },
  pmappid: 1,
  pmcompanyid: 1,
  pmroleid: { ta: 1, pr: 2 },
  redis() {
    if (this.env == 'localhost') {
      const localsettings = require('./localsettings');
      return localsettings.redis;
    }
    return {
      host: ENVINPUT.REDIS_HOST,
      port: ENVINPUT.REDIS_PORT,
      password: ENVINPUT.REDIS_PWD,
      db: ENVINPUT.REDIS_DB,
    };
  },
  database() {
    if (this.env == 'localhost') {
      const localsettings = require('./localsettings');
      return localsettings.database;
    }
    return {
      dbname: ENVINPUT.DB_NAME,
      user: ENVINPUT.DB_USER,
      password: ENVINPUT.DB_PWD,
      config: {
        host: ENVINPUT.DB_HOST,
        port: ENVINPUT.DB_PORT,
        dialect: 'mysql',
        operatorsAliases: false,
        pool: {
          max: 5,
          min: 0,
          acquire: 90000000,
          idle: 1000000,
        },
        debug: false,
        timezone: '+08:00',
        dialectOptions: {
          requestTimeout: 999999,
          // instanceName:'localhost'
        },  // 设置MSSQL超时时间
      },
    };
  },
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;
