import mongoose from 'mongoose'
import settings from "../settings"
import logger from "../utils/logger"
const { MONGO } = settings;


mongoose.connect(MONGO.url, {
  useNewUrlParser: true,
  useUnifiedTopology: true,
  useCreateIndex: true
}, function (err) {
  if (err) {
    logger.error(` MongoDD 连接失败  ${err.message} `);
    process.exit(1);
  }
})

mongoose.connection.on('disconnected', () => {
  mongoose.connect(MONGO.url)
})
mongoose.connection.on('error', err => {
  logger.error(err)
})

mongoose.connection.on('open', async () => {
  logger.info(`--- MongoDD 连接成功 ----`)
})

export default mongoose;
