import mongoose from "mongoose"

const messageSchema = new mongoose.Schema({
  messageId: { type: String, unique: true },// 发送ID
  type: { type: Number, enum: [1, 2], index: true },// 发送类型 1延时 , 2重试
  reqContent: { type: Object },// 发送内容
  resContent: { type: Array },// 相应内容
  status: { type: Number, enum: [-2, -1, 0, 1, 2], default: 0 }, // 发送状态 -2 发送失败  -1 投递失败 0 待发送 1 投递成功, 2 发送成功
}, {
  timestamps: {
    createdAt: 'createdAt',
    updatedAt: 'updatedAt'
  }
})

export default messageSchema
