const amqp = require('amqplib');
const { MQ } = require("../settings")

class RabbitmqClient {
  constructor() {
    this.socketOptions = MQ
    this.connnection = null;
    this.confirmChannel = null;
    this.channel = null;
  }

  async getConnnection() {
    try {
      if (!this.connnection) {
        const connnection = await amqp.connect(this.socketOptions);
        console.log("--- MQ 连接 成功  ----")
        this.connnection = connnection;
        this.connnection.on("error", (err) => {
          console.log("[x]Error:", err);
          this.connnection = null;
        });

        this.connnection.on("close", (err) => {
          console.log("[x]Rabbitmq is closed ", err);
          this.connnection = null;
        });
        process.once('SIGINT', this.connnection.close.bind(this.connnection));
      }
      return this.connnection;
    } catch (err) {
      console.log("---  MQ 连接 失败 ------");
      console.log(err);
      throw new Error(err.message);
    }
  }

  async getConfirmChannel() {
    try {
      if (!this.confirmChannel) {
        const connnection = await this.getConnnection();
        const confirmChannel = await connnection.createConfirmChannel();
        this.confirmChannel = confirmChannel;
        this.confirmChannel.on("error", (err) => {
          console.log("[x]Error", err);
          this.confirmChannel = null;
        });

        this.confirmChannel.on("close", (err) => {
          console.log("[*]Rabbitmq channel is closed", err);
          this.confirmChannel = null;
        });
      }

      return this.confirmChannel;
    } catch (err) {
      console.log("---  创建confirmChannel失败 ------");
      console.log(err);
      throw new Error(err.message);
    }
  }

  async getChannel() {
    try {
      if (!this.channel) {
        const connnection = await this.getConnnection();
        const channel = await connnection.createChannel();
        this.channel = channel;
        this.channel.on("error", (err) => {
          console.log("[x]Error", err);
          this.channel = null;
        });
        this.channel.on("close", (err) => {
          console.log("[*]Rabbitmq channel is closed", err);
          this.channel = null;
        });
      }
      return this.channel;
    } catch (err) {
      console.log("---  创建channe失败 ------");
      console.log(err);
      throw new Error(err.message);
    }
  }
}
module.exports = new RabbitmqClient();