import { v4 as uuidv4 } from 'uuid';

function correlation(namespace) {
  return async (ctx, next) => {
    await namespace.runPromise(() => {
      const requestId = ctx.header['x-request-id'] || uuidv4();
      namespace.set('requestId', requestId);
      return next();
    });
  }
}

export default correlation;