import { createLogger, format, transports } from 'winston';
import 'winston-daily-rotate-file';
import { getNamespace } from 'cls-hooked';
import os from 'os'
import moment from 'moment';
import path from "path"

const myFormat = format.printf(({ level, message, timestamp, requestId }) => {
  return `[${moment(timestamp).format("YYYY-MM-DD HH:mm:ss.SSS")}] [${level}] ${requestId ? ("[" + requestId + "] :") : ''} ${message}`;
});

const requestId = format((info) => {
  let { message } = info;
  const loggerNamespace = getNamespace('logger');
  let requestId = loggerNamespace.get('requestId');
  if (!requestId && Object.prototype.toString.call(message) === "[object Object]" && message.requestId) {
    requestId = message.requestId
  }
  if (Object.prototype.toString.call(message) === "[object Object]") {
    info.message = JSON.stringify(message)
  }
  info.requestId = requestId || '-'
  return info
})

const logger = createLogger({
  level: 'info',
  defaultMeta: {
    serverName: os.hostname(),
  },
  format: format.combine(
    format.timestamp(),
    requestId(),
    format.json(),
  ),
  transports: [
    new transports.DailyRotateFile({
      filename: path.join(__dirname, '../', 'logs', `%DATE%.log`),
      datePattern: 'YYYY-MM-DD',
      maxSize: '10M',
      maxFiles: '30d',
      zippedArchive: true,
    })
  ],
});

if (process.env.NODE_ENV !== 'production') {
  logger.add(new transports.Console({
    format: format.combine(
      format.timestamp(),
      format.colorize(
        {
          //各种日志的颜色
          colors: { info: 'blue', error: 'red', warn: "yellow" },
          all: true,
        }
      ),
      format.simple(),
      myFormat,
    )
  }));
}


export default logger;