#### 实现功能
* 消息请求失败重试
* 消息请求延时发送
* 全链路日志
* 界面展示

#### 启动

> npm run start
>
> 默认 3000端口

#### 界面

> http://127.0.0.1:3000/index.html

![image](public/images/image-20210801203634043.png)

#### 全链路日志
![image](public/images/iShot2021-08-04-16.18.40.png)

#### API

> 注： 全链路追踪  请求头 X-Request-Id

##### 消息请求失败重试

> 重试的阶梯时间  在 setting中配置

请求路径：/sendRetryMessage

method : post

请求参数 ： 

|  参数   |  类型  | 是否必填 |                      备注                      |
| :-----: | :----: | :------: | :--------------------------------------------: |
|   url   | string |    Y     |                 转发的请求地址                 |
| method  | string |    N     |        创建请求时使用的方法，默认 post         |
| headers | object |    N     | 请求头, 默认 Content-Type': 'application/json' |
| params  | object |    N     |      `params` 是与请求一起发送的 URL 参数      |
|  data   | object |    N     |         data  是作为请求体被发送的数据         |
| timeout |  int   |    N     |     `timeout` 指定请求超时的秒数,  默认5s      |

返回参数 ： 

```
{
    "code": 0,
    "success": true,
    "message": null,
    "data": "a102fa5c-5a5f-4282-9033-c9dfd9380584", // messageId
    "requestId": "11adcc90-98c2-4ab8-8eb6-d48d57be1374"
}
```
备注： 
```
转发调用接口返回格式规定
code 成功时返回 0 ，失败时返回具体错误码
success 是否成功 
data 成功时具体返回值，失败时为 null
message 成功时返回 null ，失败时返回具体错误消息
```





##### 消息请求延时发送

请求路径：/sendDelayMessage

method : post

请求参数 ： 

|   参数    |  类型  | 是否必填 |                       备注                       |
| :-------: | :----: | :------: | :----------------------------------------------: |
|    url    | string |    Y     |                  转发的请求地址                  |
|  method   | string |    N     |         创建请求时使用的方法，默认 post          |
|  headers  | object |    N     |  请求头, 默认 Content-Type': 'application/json'  |
|  params   | object |    N     |       `params` 是与请求一起发送的 URL 参数       |
|   data    | object |    N     |          data  是作为请求体被发送的数据          |
|  timeout  |  int   |    N     |      `timeout` 指定请求超时的秒数,  默认5s       |
| delayTime |  int   |    Y     | 延时多长时间返送 ，  单位s  ，最长不能超过49小时 |

返回参数 ： 

```
{
    "code": 0,
    "success": true,
    "message": null,
     "data": "a102fa5c-5a5f-4282-9033-c9dfd9380584", // messageId
    "requestId": "11adcc90-98c2-4ab8-8eb6-d48d57be1374"
}
```

#### filebeat 读取 日志
```
./filebeat -e -c {自定义}/filebeat.yml
```

