import mongoose from 'mongoose'
import settings from "../settings"
import logger from "../utils/logger"
const { MONGO } = settings;


mongoose.connect(MONGO.url, {
  useNewUrlParser: true,
  useUnifiedTopology: true,
  useCreateIndex: true
}, function (err) {
  if (err) {
    logger.error(` MongoDB 连接失败  ${err.message} `);
    process.exit(1);
  }
})

mongoose.connection.on('disconnected', () => {
  mongoose.connect(MONGO.url)
})
mongoose.connection.on('error', err => {
  logger.error(` MongoDB error  ${err.message} `)
  process.exit(1);
})

mongoose.connection.on('open', async () => {
  logger.info(`--- MongoDB 连接成功 ----`)
})

export default mongoose;
