const Koa = require('koa')
const app = new Koa()
const views = require('koa-views')
const json = require('koa-json')
const onerror = require('koa-onerror')
const bodyparser = require('koa-bodyparser')
const logger = require('koa-logger')
const parameter = require('koa-parameter')

const moment = require("moment")
const rabbmitmqUtil = require("./utils/rabbitmq");
rabbmitmqUtil.initQueue()
const correlation = require('./middleware/correlation');
const createNameSpace = require('cls-hooked').createNamespace;
const logNameSpace = createNameSpace('logger');

const index = require('./routes/index')
const test = require('./routes/test')




// error handler
onerror(app)

// middlewares
app.use(bodyparser({
  enableTypes: ['json', 'form', 'text']
}))
app.use(parameter(app))
app.use(json())
app.use(logger())
app.use(require('koa-static')(__dirname + '/public'))

app.use(views(__dirname + '/views', {
  extension: 'html'
}))

app.use(correlation(logNameSpace));


// logger
app.use(async (ctx, next) => {
  const start = new Date()
  await next()
  const ms = new Date() - start
  console.log(`${moment().format("YYYY-MM-DD HH:mm:ss")} ${logNameSpace.get("requestId")} ${ctx.method} ${ctx.url} - ${ms}ms`)
})

// routes
app.use(index.routes(), index.allowedMethods())
app.use(test.routes(), test.allowedMethods())




// error-handling
app.on('error', (err, ctx) => {
  console.error('server error', err, ctx)
});

module.exports = app
