const { v4: uuidv4 } = require('uuid');

function correlation(namespace) {
  return async (ctx, next) => {
    const requestId = ctx.header['x-request-id'] || uuidv4();
    namespace.run(async () => {
      namespace.set('requestId', requestId);
      await next();
    });
  }
}

module.exports = correlation;